/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.CacheMap;
import org.apache.cxf.common.util.CachedClass;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxb.JAXBUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBContextCache {
    private static final Map<Set<Class<?>>, CachedContextAndSchemas> JAXBCONTEXT_CACHE = new CacheMap();
    private static final Map<Package, CachedClass> OBJECT_FACTORY_CACHE = new CacheMap<Package, CachedClass>();

    private JAXBContextCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        Map<Object, Object> map = JAXBCONTEXT_CACHE;
        synchronized (map) {
            JAXBCONTEXT_CACHE.clear();
        }
        map = OBJECT_FACTORY_CACHE;
        synchronized (map) {
            OBJECT_FACTORY_CACHE.clear();
        }
    }

    public static void scanPackages(Set<Class<?>> classes) {
        JAXBUtils.scanPackages(classes, OBJECT_FACTORY_CACHE);
    }

    public static CachedContextAndSchemas getCachedContextAndSchemas(Class<?> cls) throws JAXBException {
        HashSet classes = new HashSet();
        classes.add(cls);
        JAXBContextCache.scanPackages(classes);
        return JAXBContextCache.getCachedContextAndSchemas(classes, null, null, null, false);
    }

    public static CachedContextAndSchemas getCachedContextAndSchemas(String pkg, Map<String, Object> props, ClassLoader loader) throws JAXBException {
        HashSet classes = new HashSet();
        JAXBContextCache.addPackage(classes, pkg, loader);
        return JAXBContextCache.getCachedContextAndSchemas(classes, null, props, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedContextAndSchemas getCachedContextAndSchemas(Set<Class<?>> classes, String defaultNs, Map<String, Object> props, Collection<Object> typeRefs, boolean exact) throws JAXBException {
        Map<Set<Class<?>>, CachedContextAndSchemas> map;
        for (Class<?> clz : classes) {
            if (!clz.getName().endsWith("ObjectFactory") || !JAXBContextCache.checkObjectFactoryNamespaces(clz)) continue;
            defaultNs = null;
        }
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        if (defaultNs != null) {
            map2.put("com.sun.xml.bind.defaultNamespaceRemap", defaultNs);
        }
        if (props != null) {
            map2.putAll(props);
        }
        CachedContextAndSchemas cachedContextAndSchemas = null;
        JAXBContext context = null;
        if (typeRefs == null || typeRefs.isEmpty()) {
            map = JAXBCONTEXT_CACHE;
            synchronized (map) {
                if (exact) {
                    cachedContextAndSchemas = JAXBCONTEXT_CACHE.get(classes);
                } else {
                    for (Map.Entry<Set<Class<?>>, CachedContextAndSchemas> k : JAXBCONTEXT_CACHE.entrySet()) {
                        Set<Class<Class<?>>> key = k.getKey();
                        if (key == null || !key.containsAll(classes)) continue;
                        cachedContextAndSchemas = k.getValue();
                        break;
                    }
                }
            }
        }
        if (cachedContextAndSchemas != null && (context = cachedContextAndSchemas.getContext()) == null) {
            JAXBCONTEXT_CACHE.remove(cachedContextAndSchemas.getClasses());
            cachedContextAndSchemas = null;
        }
        if (context == null) {
            block21: {
                try {
                    context = JAXBContextCache.createContext(classes, map2, typeRefs);
                }
                catch (JAXBException ex) {
                    boolean added = JAXBContextCache.addJaxbObjectFactory(ex, classes);
                    while (cachedContextAndSchemas == null && added) {
                        try {
                            context = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]), null);
                        }
                        catch (JAXBException e) {
                            throw ex;
                        }
                    }
                    if (context != null) break block21;
                    throw ex;
                }
            }
            cachedContextAndSchemas = new CachedContextAndSchemas(context, classes);
            map = JAXBCONTEXT_CACHE;
            synchronized (map) {
                if (typeRefs == null || typeRefs.isEmpty()) {
                    JAXBCONTEXT_CACHE.put(classes, cachedContextAndSchemas);
                }
            }
        }
        return cachedContextAndSchemas;
    }

    private static boolean checkObjectFactoryNamespaces(Class<?> clz) {
        for (Method meth : clz.getMethods()) {
            XmlElementDecl decl = meth.getAnnotation(XmlElementDecl.class);
            if (decl == null || !XmlElementDecl.GLOBAL.class.equals((Object)decl.scope()) || !StringUtils.isEmpty(decl.namespace())) continue;
            return true;
        }
        return false;
    }

    private static JAXBContext createContext(Set<Class<?>> classes, Map<String, Object> map, Collection<Object> typeRefs) throws JAXBException {
        JAXBContext ctx;
        if (typeRefs != null && !typeRefs.isEmpty()) {
            Class<?> fact = null;
            String pfx = "com.sun.xml.bind.";
            try {
                fact = ClassLoaderUtils.loadClass("com.sun.xml.bind.v2.ContextFactory", JAXBContextCache.class);
            }
            catch (Throwable t) {
                try {
                    fact = ClassLoaderUtils.loadClass("com.sun.xml.internal.bind.v2.ContextFactory", JAXBContextCache.class);
                    pfx = "com.sun.xml.internal.bind.";
                }
                catch (Throwable t2) {
                    // empty catch block
                }
            }
            if (fact != null) {
                for (Method m : fact.getMethods()) {
                    if (!"createContext".equals(m.getName()) || m.getParameterTypes().length != 9) continue;
                    try {
                        return (JAXBContext)m.invoke(null, classes.toArray(new Class[classes.size()]), typeRefs, map.get(pfx + "subclassReplacements"), map.get(pfx + "defaultNamespaceRemap"), map.get(pfx + "c14n") == null ? Boolean.FALSE : map.get(pfx + "c14n"), map.get(pfx + "v2.model.annotation.RuntimeAnnotationReader"), map.get(pfx + "XmlAccessorFactory") == null ? Boolean.FALSE : map.get(pfx + "XmlAccessorFactory"), map.get(pfx + "treatEverythingNillable") == null ? Boolean.FALSE : map.get(pfx + "treatEverythingNillable"), map.get("retainReferenceToInfo") == null ? Boolean.FALSE : map.get("retainReferenceToInfo"));
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            ctx = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]), map);
        }
        catch (JAXBException ex) {
            if (map.containsKey("com.sun.xml.bind.defaultNamespaceRemap") && ex.getMessage() != null && ex.getMessage().contains("com.sun.xml.bind.defaultNamespaceRemap")) {
                map.put("com.sun.xml.internal.bind.defaultNamespaceRemap", map.remove("com.sun.xml.bind.defaultNamespaceRemap"));
                ctx = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]), map);
            }
            throw ex;
        }
        return ctx;
    }

    private static boolean addJaxbObjectFactory(JAXBException e1, Set<Class<?>> classes) {
        boolean added = false;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(bout);
        e1.printStackTrace(pout);
        String str = new String(bout.toByteArray());
        Pattern pattern = Pattern.compile("(?<=There's\\sno\\sObjectFactory\\swith\\san\\s@XmlElementDecl\\sfor\\sthe\\selement\\s\\{)\\S*(?=\\})");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String pkgName = JAXBUtils.namespaceURIToPackage(matcher.group());
            try {
                Class<?> clz = JAXBContextCache.class.getClassLoader().loadClass(pkgName + "." + "ObjectFactory");
                if (classes.contains(clz)) continue;
                classes.add(clz);
                added = true;
            }
            catch (ClassNotFoundException e) {}
        }
        return added;
    }

    public static void addPackage(Set<Class<?>> classes, String pkg, ClassLoader loader) {
        try {
            classes.add(Class.forName(pkg + ".ObjectFactory", false, loader));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            InputStream ins = loader.getResourceAsStream("/" + pkg.replace('.', '/') + "/jaxb.index");
            BufferedReader reader = new BufferedReader(new InputStreamReader(ins, "UTF-8"));
            if (!StringUtils.isEmpty(pkg)) {
                pkg = pkg + ".";
            }
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).indexOf("#") != -1) {
                    line = line.substring(0, line.indexOf("#"));
                }
                if (!StringUtils.isEmpty(line)) {
                    try {
                        Class<?> ncls = Class.forName(pkg + line, false, loader);
                        classes.add(ncls);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CachedContextAndSchemas {
        private WeakReference<JAXBContext> context;
        private WeakReference<Set<Class<?>>> classes;
        private Collection<DOMSource> schemas;

        CachedContextAndSchemas(JAXBContext context, Set<Class<?>> classes) {
            this.context = new WeakReference<JAXBContext>(context);
            this.classes = new WeakReference(classes);
        }

        public JAXBContext getContext() {
            return (JAXBContext)this.context.get();
        }

        public Set<Class<?>> getClasses() {
            return (Set)this.classes.get();
        }

        public void setClasses(Set<Class<?>> cls) {
            this.classes = new WeakReference(cls);
        }

        public Collection<DOMSource> getSchemas() {
            return this.schemas;
        }

        public void setSchemas(Collection<DOMSource> schemas) {
            this.schemas = schemas;
        }
    }
}

