/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfse;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServiceRef;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.ServiceImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.jbi.JBIDestination;
import org.apache.cxf.transport.jbi.JBIDispatcherUtil;
import org.apache.cxf.transport.jbi.JBITransportFactory;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.apache.cxf.xmlbeans.XmlBeansDataBinding;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.cxfse.CxfSeComponent;
import org.apache.servicemix.cxfse.JBIContext;
import org.apache.servicemix.cxfse.interceptors.AttachmentInInterceptor;
import org.apache.servicemix.cxfse.interceptors.AttachmentOutInterceptor;
import org.apache.servicemix.cxfse.support.ReflectionUtils;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.soap.util.DomUtil;
import org.springframework.util.ReflectionUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfSeEndpoint
extends ProviderEndpoint
implements InterceptorProvider {
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    private Object pojo;
    private EndpointImpl endpoint;
    private String address;
    private ServerFactoryBean sf;
    private Server server;
    private List<Interceptor<? extends Message>> in = new CopyOnWriteArrayList<Interceptor<? extends Message>>();
    private List<Interceptor<? extends Message>> out = new CopyOnWriteArrayList<Interceptor<? extends Message>>();
    private List<Interceptor<? extends Message>> outFault = new CopyOnWriteArrayList<Interceptor<? extends Message>>();
    private List<Interceptor<? extends Message>> inFault = new CopyOnWriteArrayList<Interceptor<? extends Message>>();
    private Map properties;
    private boolean mtomEnabled;
    private boolean useJBIWrapper = true;
    private boolean useSOAPEnvelope = true;
    private boolean useAegis;
    private boolean useXmlBeans;
    private QName pojoService;
    private QName pojoEndpoint;
    private QName pojoInterfaceName;
    private Server soapBindingServer;
    private AbstractDataBinding dataBinding;

    public Object getPojo() {
        return this.pojo;
    }

    public void setPojo(Object pojo) {
        this.pojo = pojo;
    }

    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        return this.outFault;
    }

    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        return this.inFault;
    }

    public List<Interceptor<? extends Message>> getInInterceptors() {
        return this.in;
    }

    public List<Interceptor<? extends Message>> getOutInterceptors() {
        return this.out;
    }

    public void setInInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.in.addAll(interceptors);
    }

    public void setInFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.inFault.addAll(interceptors);
    }

    public void setOutInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.out.addAll(interceptors);
    }

    public void setOutFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.outFault.addAll(interceptors);
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void validate() throws DeploymentException {
        if (this.getPojo() == null) {
            throw new DeploymentException("pojo attribute is mandatory.");
        }
        String address = "jbi://" + ID_GENERATOR.generateSanitizedId();
        if (this.isUseAegis()) {
            this.sf = new ServerFactoryBean();
            this.sf.setServiceBean(this.getPojo());
            this.sf.setAddress(address);
            if (this.getDataBinding() != null && this.getDataBinding() instanceof AegisDatabinding) {
                this.sf.getServiceFactory().setDataBinding((DataBinding)this.getDataBinding());
            } else {
                this.sf.getServiceFactory().setDataBinding((DataBinding)new AegisDatabinding());
            }
            this.sf.getServiceFactory().setPopulateFromClass(true);
            this.sf.setStart(false);
            if (this.isUseJBIWrapper()) {
                this.sf.setBindingId("http://cxf.apache.org/bindings/jbi");
            }
            if (this.getPojoService() != null) {
                this.sf.setServiceName(this.getPojoService());
            }
            if (this.getPojoEndpoint() != null) {
                this.sf.setEndpointName(this.getPojoEndpoint());
            }
            this.cleanUpDeadDestination();
            this.server = this.sf.create();
            this.server.getEndpoint().getInInterceptors().addAll(this.getInInterceptors());
            this.server.getEndpoint().getInFaultInterceptors().addAll(this.getInFaultInterceptors());
            this.server.getEndpoint().getOutInterceptors().addAll(this.getOutInterceptors());
            this.server.getEndpoint().getOutFaultInterceptors().addAll(this.getOutFaultInterceptors());
            if (this.isMtomEnabled()) {
                this.server.getEndpoint().getInInterceptors().add(new AttachmentInInterceptor());
                this.server.getEndpoint().getOutInterceptors().add(new AttachmentOutInterceptor());
            }
            if (this.sf.getServiceFactory().getServiceQName() != null) {
                if (this.getPojoService() == null) {
                    this.setPojoService(this.sf.getServiceFactory().getServiceQName());
                }
                if (this.getService() == null) {
                    this.setService(this.sf.getServiceFactory().getServiceQName());
                }
            }
            if (this.sf.getServiceFactory().getEndpointInfo().getName() != null) {
                if (this.getPojoEndpoint() == null) {
                    this.setPojoEndpoint(this.sf.getServiceFactory().getEndpointInfo().getName());
                }
                if (this.getEndpoint() == null) {
                    this.setEndpoint(this.sf.getServiceFactory().getEndpointInfo().getName().getLocalPart());
                }
            }
            if (this.sf.getServiceFactory().getInterfaceName() != null) {
                this.setPojoInterfaceName(this.sf.getServiceFactory().getInterfaceName());
                if (this.getInterfaceName() == null) {
                    this.setInterfaceName(this.sf.getServiceFactory().getInterfaceName());
                }
            }
        } else {
            JaxWsServiceFactoryBean serviceFactory = new JaxWsServiceFactoryBean();
            serviceFactory.setPopulateFromClass(true);
            if (this.getPojoService() != null) {
                serviceFactory.setServiceName(this.getPojoService());
            }
            if (this.getPojoEndpoint() != null) {
                serviceFactory.setEndpointName(this.getPojoEndpoint());
            }
            this.endpoint = new EndpointImpl(this.getBus(), this.getPojo(), new JaxWsServerFactoryBean(serviceFactory));
            if (this.isUseJBIWrapper()) {
                this.endpoint.setBindingUri("http://cxf.apache.org/bindings/jbi");
            }
            if (this.isUseXmlBeans()) {
                if (this.getDataBinding() != null && this.getDataBinding() instanceof XmlBeansDataBinding) {
                    this.endpoint.setDataBinding((DataBinding)this.getDataBinding());
                } else {
                    this.endpoint.setDataBinding((DataBinding)new XmlBeansDataBinding());
                }
            } else if (this.getDataBinding() != null && this.getDataBinding() instanceof JAXBDataBinding) {
                this.endpoint.setDataBinding((DataBinding)this.getDataBinding());
            }
            this.endpoint.setInInterceptors(this.getInInterceptors());
            this.endpoint.setInFaultInterceptors(this.getInFaultInterceptors());
            this.endpoint.setOutInterceptors(this.getOutInterceptors());
            this.endpoint.setOutFaultInterceptors(this.getOutFaultInterceptors());
            if (this.isMtomEnabled()) {
                this.endpoint.getInInterceptors().add(new AttachmentInInterceptor());
                this.endpoint.getOutInterceptors().add(new AttachmentOutInterceptor());
            }
            JaxWsImplementorInfo implInfo = new JaxWsImplementorInfo(this.getPojo().getClass());
            if (this.getPojoService() == null) {
                this.setPojoService(implInfo.getServiceName());
            }
            this.setPojoInterfaceName(implInfo.getInterfaceName());
            if (this.getPojoEndpoint() == null) {
                this.setPojoEndpoint(implInfo.getEndpointName());
            }
            if (this.getService() == null) {
                this.setService(implInfo.getServiceName());
            }
            if (this.getInterfaceName() == null) {
                this.setInterfaceName(implInfo.getInterfaceName());
            }
            if (this.getEndpoint() == null) {
                this.setEndpoint(implInfo.getEndpointName().getLocalPart());
            }
        }
        if (!this.isUseAegis()) {
            this.cleanUpDeadDestination();
            this.endpoint.publish(address);
            this.server = this.endpoint.getServer();
        }
        if (this.getService() == null) {
            this.setService(this.server.getEndpoint().getService().getName());
        }
        if (this.getEndpoint() == null) {
            this.setEndpoint(this.server.getEndpoint().getEndpointInfo().getName().getLocalPart());
        }
        this.setPojoService(this.server.getEndpoint().getService().getName());
        this.setPojoEndpoint(this.server.getEndpoint().getEndpointInfo().getName());
        if (!this.isUseJBIWrapper() && !this.isUseSOAPEnvelope()) {
            this.removeInterceptor(this.server.getEndpoint().getBinding().getInInterceptors(), "ReadHeadersInterceptor");
            this.removeInterceptor(this.server.getEndpoint().getBinding().getInFaultInterceptors(), "ReadHeadersInterceptor");
            this.removeInterceptor(this.server.getEndpoint().getBinding().getOutInterceptors(), "SoapOutInterceptor");
            this.removeInterceptor(this.server.getEndpoint().getBinding().getOutFaultInterceptors(), "SoapOutInterceptor");
            this.removeInterceptor(this.server.getEndpoint().getBinding().getOutInterceptors(), "StaxOutInterceptor");
        }
        try {
            this.definition = new ServiceWSDLBuilder(this.getBus(), new ServiceInfo[]{(ServiceInfo)this.server.getEndpoint().getService().getServiceInfos().iterator().next()}).build();
            this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.definition);
        }
        catch (WSDLException e) {
            throw new DeploymentException((Throwable)e);
        }
        super.validate();
    }

    private void removeInterceptor(List<Interceptor<? extends Message>> interceptors, String whichInterceptor) {
        for (Interceptor<? extends Message> interceptor : interceptors) {
            if (!interceptor.getClass().getName().endsWith(whichInterceptor)) continue;
            interceptors.remove(interceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() != ExchangeStatus.ACTIVE) {
            return;
        }
        JBIContext.setMessageExchange(exchange);
        try {
            QName opeName = exchange.getOperation();
            EndpointInfo ei = this.server.getEndpoint().getEndpointInfo();
            if (opeName == null) {
                if (ei.getBinding().getOperations().size() == 1) {
                    opeName = ((BindingOperationInfo)ei.getBinding().getOperations().iterator().next()).getName();
                    exchange.setOperation(opeName);
                } else {
                    NormalizedMessage nm = exchange.getMessage("in");
                    if (this.soapBindingServer == null) {
                        Object sfForSoapBinding = null;
                        sfForSoapBinding = this.isUseAegis() ? new ServerFactoryBean() : new JaxWsServerFactoryBean();
                        sfForSoapBinding.setServiceBean(this.getPojo());
                        sfForSoapBinding.getServiceFactory().setPopulateFromClass(true);
                        sfForSoapBinding.setStart(false);
                        sfForSoapBinding.setAddress("/dummy");
                        this.soapBindingServer = sfForSoapBinding.create();
                    }
                    Message message = this.soapBindingServer.getEndpoint().getBinding().createMessage();
                    opeName = this.findOperation(nm, message, exchange);
                    exchange.setOperation(opeName);
                }
            }
            JBITransportFactory jbiTransportFactory = (JBITransportFactory)((ConduitInitiatorManager)this.getBus().getExtension(ConduitInitiatorManager.class)).getConduitInitiator("http://cxf.apache.org/transports/jbi");
            exchange.setService(this.getPojoService());
            exchange.setInterfaceName(this.getPojoInterfaceName());
            JBIDestination jbiDestination = jbiTransportFactory.getDestination(this.getPojoService().toString() + this.getPojoInterfaceName().toString());
            DeliveryChannel dc = this.getContext().getDeliveryChannel();
            jbiTransportFactory.setDeliveryChannel(dc);
            jbiDestination.setDeliveryChannel(dc);
            if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
                jbiDestination.getJBIDispatcherUtil().dispatch(exchange);
            }
            if (exchange instanceof InOnly || exchange instanceof RobustInOnly) {
                exchange.setStatus(ExchangeStatus.DONE);
                dc.send(exchange);
            }
        }
        finally {
            JBIContext.setMessageExchange(null);
        }
    }

    public void start() throws Exception {
        super.start();
        if (this.isUseAegis()) {
            this.server.start();
        }
        ReflectionUtils.doWithFields(this.getPojo().getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                if (field.getAnnotation(WebServiceRef.class) != null) {
                    ServiceImpl s = new ServiceImpl(CxfSeEndpoint.this.getBus(), null, null, field.getType(), new WebServiceFeature[0]);
                    s.addPort(new QName("port"), "http://cxf.apache.org/transports/jbi", "jbi://" + ID_GENERATOR.generateSanitizedId());
                    Object o = s.getPort(new QName("port"), field.getType());
                    field.setAccessible(true);
                    field.set(CxfSeEndpoint.this.getPojo(), o);
                }
            }
        });
        ReflectionUtils.callLifecycleMethod(this.getPojo(), PostConstruct.class);
        this.injectPojo();
    }

    public void stop() throws Exception {
        if (this.isUseAegis()) {
            this.server.stop();
        } else {
            this.endpoint.stop();
        }
        ReflectionUtils.callLifecycleMethod(this.getPojo(), PreDestroy.class);
        JBIDispatcherUtil.clean();
        JBITransportFactory jbiTransportFactory = (JBITransportFactory)((ConduitInitiatorManager)this.getBus().getExtension(ConduitInitiatorManager.class)).getConduitInitiator("http://cxf.apache.org/transports/jbi");
        jbiTransportFactory.setDeliveryChannel(null);
        jbiTransportFactory.removeDestination(this.getPojoService().toString() + this.getPojoInterfaceName().toString());
        super.stop();
    }

    protected Bus getBus() {
        return ((CxfSeComponent)this.getServiceUnit().getComponent()).getBus();
    }

    private void cleanUpDeadDestination() throws DeploymentException {
        JBITransportFactory jbiTransportFactory;
        try {
            jbiTransportFactory = (JBITransportFactory)((ConduitInitiatorManager)this.getBus().getExtension(ConduitInitiatorManager.class)).getConduitInitiator("http://cxf.apache.org/transports/jbi");
        }
        catch (BusException e) {
            throw new DeploymentException((Throwable)e);
        }
        if (jbiTransportFactory != null && this.getPojoService() != null && this.getPojoInterfaceName() != null) {
            jbiTransportFactory.removeDestination(this.getPojoService().toString() + this.getPojoInterfaceName().toString());
        }
    }

    private QName findOperation(NormalizedMessage nm, Message message, MessageExchange exchange) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        Element element = new SourceTransformer().toDOMElement(nm.getContent());
        if (!this.useJBIWrapper) {
            Element bodyElement;
            SoapVersion soapVersion = ((SoapMessage)message).getVersion();
            if (element != null && (bodyElement = (Element)element.getElementsByTagNameNS(element.getNamespaceURI(), soapVersion.getBody().getLocalPart()).item(0)) != null) {
                element = (Element)bodyElement.getFirstChild();
            }
        } else {
            element = DomUtil.getFirstChildElement((Node)DomUtil.getFirstChildElement((Node)element));
        }
        QName opeName = new QName(element.getNamespaceURI(), element.getLocalName());
        SoapBindingInfo binding = (SoapBindingInfo)this.soapBindingServer.getEndpoint().getEndpointInfo().getBinding();
        for (BindingOperationInfo op : binding.getOperations()) {
            String style = binding.getStyle(op.getOperationInfo());
            if (style == null) {
                style = binding.getStyle();
            }
            if ("document".equals(style)) {
                if (!op.getName().getLocalPart().equals(opeName.getLocalPart())) continue;
                return new QName(this.getPojoService().getNamespaceURI(), opeName.getLocalPart());
            }
            throw new Fault((Throwable)new Exception("Operation must bound on this MessageExchange if use rpc mode"));
        }
        throw new Fault((Throwable)new Exception("Operation not bound on this MessageExchange"));
    }

    @PostConstruct
    protected void injectPojo() {
        try {
            ComponentContext context = this.getContext();
            Method mth = this.pojo.getClass().getMethod("setContext", ComponentContext.class);
            if (mth != null) {
                mth.invoke(this.pojo, context);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setUseJBIWrapper(boolean useJBIWrapper) {
        this.useJBIWrapper = useJBIWrapper;
    }

    public boolean isUseJBIWrapper() {
        return this.useJBIWrapper;
    }

    public void setUseSOAPEnvelope(boolean useSOAPEnvelope) {
        this.useSOAPEnvelope = useSOAPEnvelope;
    }

    public boolean isUseSOAPEnvelope() {
        return this.useSOAPEnvelope;
    }

    public void setUseAegis(boolean useAegis) {
        this.useAegis = useAegis;
    }

    public boolean isUseAegis() {
        return this.useAegis;
    }

    public void setPojoService(QName pojoService) {
        this.pojoService = pojoService;
    }

    public QName getPojoService() {
        return this.pojoService;
    }

    public void setPojoEndpoint(QName pojoEndpoint) {
        this.pojoEndpoint = pojoEndpoint;
    }

    public QName getPojoEndpoint() {
        return this.pojoEndpoint;
    }

    protected void setPojoInterfaceName(QName pojoInterfaceName) {
        this.pojoInterfaceName = pojoInterfaceName;
    }

    protected QName getPojoInterfaceName() {
        return this.pojoInterfaceName;
    }

    public void setUseXmlBeans(boolean useXmlBeans) {
        this.useXmlBeans = useXmlBeans;
    }

    public boolean isUseXmlBeans() {
        return this.useXmlBeans;
    }

    public void setDataBinding(AbstractDataBinding dataBinding) {
        this.dataBinding = dataBinding;
    }

    public AbstractDataBinding getDataBinding() {
        return this.dataBinding;
    }
}

