/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.configuration.NullConfigurer;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.apache.cxf.configuration.spring.ConfigurerImpl;
import org.apache.cxf.helpers.CastUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class BusWiringBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    Bus bus;
    String busName;

    public BusWiringBeanFactoryPostProcessor() {
    }

    public BusWiringBeanFactoryPostProcessor(Bus b) {
        this.bus = b;
    }

    public BusWiringBeanFactoryPostProcessor(String n) {
        this.busName = n;
    }

    private static Bus getBusForName(String name, ApplicationContext context) {
        if (!context.containsBean(name)) {
            SpringBus b = new SpringBus();
            b.setApplicationContext(context);
            ConfigurableApplicationContext cctx = (ConfigurableApplicationContext)context;
            cctx.getBeanFactory().registerSingleton(name, (Object)b);
        }
        return (Bus)context.getBean(name, Bus.class);
    }

    private Object getBusForName(String name, ConfigurableListableBeanFactory factory) {
        if (!factory.containsBeanDefinition(name)) {
            DefaultListableBeanFactory df = (DefaultListableBeanFactory)factory;
            df.registerBeanDefinition(name, (BeanDefinition)new RootBeanDefinition(SpringBus.class));
        }
        return new RuntimeBeanReference(name);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
        Object inject = this.bus;
        if (inject == null) {
            inject = this.getBusForName("cxf", factory);
        } else if (!factory.containsBeanDefinition("cxf") && !factory.containsSingleton("cxf")) {
            factory.registerSingleton("cxf", (Object)this.bus);
        }
        for (String beanName : factory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = factory.getBeanDefinition(beanName);
            BusWiringType type = (BusWiringType)beanDefinition.getAttribute(AbstractBeanDefinitionParser.WIRE_BUS_ATTRIBUTE);
            if (type == null) continue;
            String busname = (String)beanDefinition.getAttribute(AbstractBeanDefinitionParser.WIRE_BUS_NAME);
            Object inj = inject;
            if (busname != null) {
                if (this.bus != null) continue;
                inj = this.getBusForName(busname, factory);
            }
            beanDefinition.removeAttribute(AbstractBeanDefinitionParser.WIRE_BUS_NAME);
            beanDefinition.removeAttribute(AbstractBeanDefinitionParser.WIRE_BUS_ATTRIBUTE);
            if (BusWiringType.PROPERTY == type) {
                beanDefinition.getPropertyValues().addPropertyValue("bus", inj);
                continue;
            }
            if (BusWiringType.CONSTRUCTOR != type) continue;
            ConstructorArgumentValues constructorArgs = beanDefinition.getConstructorArgumentValues();
            this.insertConstructorArg(constructorArgs, inj);
        }
    }

    private void insertConstructorArg(ConstructorArgumentValues constructorArgs, Object valueToInsert) {
        ArrayList genericArgs = new ArrayList(CastUtils.cast((List)constructorArgs.getGenericArgumentValues()));
        HashMap indexedArgs = new HashMap(CastUtils.cast((Map)constructorArgs.getIndexedArgumentValues()));
        constructorArgs.clear();
        for (ConstructorArgumentValues.ValueHolder valueHolder : genericArgs) {
            constructorArgs.addGenericArgumentValue(valueHolder);
        }
        for (Map.Entry entry : indexedArgs.entrySet()) {
            constructorArgs.addIndexedArgumentValue((Integer)entry.getKey() + 1, (ConstructorArgumentValues.ValueHolder)entry.getValue());
        }
        constructorArgs.addIndexedArgumentValue(0, valueToInsert);
    }

    @Deprecated
    public static void updateBusReferencesInContext(Bus bus, ApplicationContext ctx) {
        Configurer conf = (Configurer)bus.getExtension(Configurer.class);
        if (conf instanceof NullConfigurer) {
            bus.setExtension((Object)new ConfigurerImpl(ctx), Configurer.class);
            conf = (Configurer)bus.getExtension(Configurer.class);
        } else if (conf instanceof ConfigurerImpl) {
            ((ConfigurerImpl)conf).addApplicationContext(ctx);
        }
        if (ctx instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext cctx = (ConfigurableApplicationContext)ctx;
            new BusWiringBeanFactoryPostProcessor(bus).postProcessBeanFactory(cctx.getBeanFactory());
        }
    }

    public static Bus addDefaultBus(ApplicationContext ctx) {
        if (!ctx.containsBean("cxf")) {
            Bus b = BusWiringBeanFactoryPostProcessor.getBusForName("cxf", ctx);
            if (ctx instanceof ConfigurableApplicationContext) {
                ConfigurableApplicationContext cctx = (ConfigurableApplicationContext)ctx;
                new BusWiringBeanFactoryPostProcessor(b).postProcessBeanFactory(cctx.getBeanFactory());
            }
        }
        return (Bus)Bus.class.cast(ctx.getBean("cxf", Bus.class));
    }

    public static Bus addBus(ApplicationContext ctx, String name) {
        return BusWiringBeanFactoryPostProcessor.getBusForName(name, ctx);
    }
}

