/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding.stax;

import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.common.xmlschema.XmlSchemaConstants;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.databinding.stax.XMLStreamWriterCallback;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxDataBinding
extends AbstractDataBinding {
    private XMLStreamDataReader xsrReader = new XMLStreamDataReader();
    private XMLStreamDataWriter xswWriter = new XMLStreamDataWriter();

    public void initialize(Service service) {
        for (ServiceInfo serviceInfo : service.getServiceInfos()) {
            SchemaCollection schemaCollection = serviceInfo.getXmlSchemaCollection();
            if (schemaCollection.getXmlSchemas().length > 1) continue;
            new ServiceModelVisitor(serviceInfo){

                public void begin(MessagePartInfo part) {
                    if (part.getTypeQName() != null || part.getElementQName() != null) {
                        return;
                    }
                    part.setTypeQName(XmlSchemaConstants.ANY_TYPE_QNAME);
                }
            }.walk();
        }
    }

    public <T> DataReader<T> createReader(Class<T> cls) {
        if (cls == XMLStreamReader.class) {
            return this.xsrReader;
        }
        throw new UnsupportedOperationException("The type " + cls.getName() + " is not supported.");
    }

    public Class<?>[] getSupportedReaderFormats() {
        return new Class[]{XMLStreamReader.class};
    }

    public <T> DataWriter<T> createWriter(Class<T> cls) {
        if (cls == XMLStreamWriter.class) {
            return this.xswWriter;
        }
        throw new UnsupportedOperationException("The type " + cls.getName() + " is not supported.");
    }

    public Class<?>[] getSupportedWriterFormats() {
        return new Class[]{XMLStreamWriter.class, Node.class};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XMLStreamDataWriter
    implements DataWriter<XMLStreamWriter> {
        private static final Logger LOG = LogUtils.getL7dLogger(XMLStreamDataWriter.class);

        public void write(Object obj, MessagePartInfo part, XMLStreamWriter output) {
            this.write(obj, output);
        }

        public void write(Object obj, XMLStreamWriter writer) {
            block4: {
                try {
                    if (obj instanceof XMLStreamReader) {
                        XMLStreamReader xmlStreamReader = (XMLStreamReader)obj;
                        StaxUtils.copy((XMLStreamReader)xmlStreamReader, (XMLStreamWriter)writer);
                        xmlStreamReader.close();
                        break block4;
                    }
                    if (obj instanceof XMLStreamWriterCallback) {
                        ((XMLStreamWriterCallback)obj).write(writer);
                        break block4;
                    }
                    throw new UnsupportedOperationException("Data types of " + obj.getClass() + " are not supported.");
                }
                catch (XMLStreamException e) {
                    throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
                }
            }
        }

        public void setSchema(Schema s) {
        }

        public void setAttachments(Collection<Attachment> attachments) {
        }

        public void setProperty(String key, Object value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XMLStreamDataReader
    implements DataReader<XMLStreamReader> {
        public Object read(MessagePartInfo part, XMLStreamReader input) {
            return this.read(null, input, part.getTypeClass());
        }

        public Object read(QName name, XMLStreamReader input, Class type) {
            return input;
        }

        public Object read(XMLStreamReader reader) {
            return reader;
        }

        public void setSchema(Schema s) {
        }

        public void setAttachments(Collection<Attachment> attachments) {
        }

        public void setProperty(String prop, Object value) {
        }
    }
}

