/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxf.binding.jbi.interceptor;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.servicemix.cxf.binding.jbi.JBIBindingInfo;
import org.apache.servicemix.cxf.binding.jbi.JBIConstants;

public class JBIWrapperInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(JBIWrapperInInterceptor.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();

    public JBIWrapperInInterceptor() {
        super("unmarshal");
    }

    public void handleMessage(Message message) throws Fault {
        if (this.isGET(message)) {
            LOG.fine("JbiMessageInInterceptor skipped in HTTP GET method");
            return;
        }
        XMLStreamReader xsr = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        DepthXMLStreamReader reader = new DepthXMLStreamReader(xsr);
        Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
        BindingInfo binding = ep.getEndpointInfo().getBinding();
        if (!(binding instanceof JBIBindingInfo)) {
            throw new IllegalStateException(new org.apache.cxf.common.i18n.Message("NEED_JBIBINDING", BUNDLE, new Object[0]).toString());
        }
        if (!StaxUtils.toNextElement((DepthXMLStreamReader)reader)) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_OPERATION_ELEMENT", BUNDLE, new Object[0]));
        }
        Exchange ex = message.getExchange();
        QName startQName = reader.getName();
        if (startQName.getLocalPart().equals("JBIFault")) {
            message.getInterceptorChain().abort();
            if (ep.getInFaultObserver() != null) {
                ep.getInFaultObserver().onMessage(message);
                return;
            }
        }
        if (!startQName.equals(JBIConstants.JBI_WRAPPER_MESSAGE)) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_JBI_MESSAGE_ELEMENT", BUNDLE, new Object[0]));
        }
        try {
            BindingOperationInfo bop = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
            DataReader dr = this.getDataReader(message);
            boolean requestor = this.isRequestor(message);
            MessageContentsList parameters = new MessageContentsList();
            reader.next();
            ServiceInfo si = bop.getBinding().getService();
            MessageInfo msgInfo = this.setMessage(message, bop, requestor, si);
            message.put(MessageInfo.class, (Object)msgInfo);
            if (!bop.isUnwrappedCapable()) {
                for (MessagePartInfo part : msgInfo.getMessageParts()) {
                    this.readJBIWrapper(reader);
                    if (part.isElement()) {
                        reader.next();
                        if (!StaxUtils.toNextElement((DepthXMLStreamReader)reader)) {
                            throw new Fault(new org.apache.cxf.common.i18n.Message("EXPECTED_ELEMENT_IN_PART", BUNDLE, new Object[0]));
                        }
                    }
                    parameters.put(part, dr.read(part, (Object)reader));
                    if (!part.isElement()) continue;
                    reader.next();
                }
                int ev = reader.getEventType();
                while (ev != 2 && ev != 1 && ev != 8) {
                    ev = reader.next();
                }
            } else if (bop.isUnwrappedCapable() && ((MessagePartInfo)msgInfo.getMessageParts().get(0)).getTypeClass() != null) {
                this.readJBIWrapper(reader);
                if (((MessagePartInfo)msgInfo.getMessageParts().get(0)).isElement()) {
                    reader.next();
                    if (!StaxUtils.toNextElement((DepthXMLStreamReader)reader)) {
                        throw new Fault(new org.apache.cxf.common.i18n.Message("EXPECTED_ELEMENT_IN_PART", BUNDLE, new Object[0]));
                    }
                }
                Object wrappedObject = dr.read((MessagePartInfo)msgInfo.getMessageParts().get(0), (Object)xsr);
                parameters.put((MessagePartInfo)msgInfo.getMessageParts().get(0), wrappedObject);
            } else {
                if (bop.isUnwrappedCapable()) {
                    bop = bop.getUnwrappedOperation();
                }
                msgInfo = this.setMessage(message, bop, requestor, si);
                message.put(MessageInfo.class, (Object)msgInfo);
                for (MessagePartInfo part : msgInfo.getMessageParts()) {
                    this.readJBIWrapper(reader);
                    if (part.isElement()) {
                        reader.next();
                        reader.next();
                        if (!StaxUtils.toNextElement((DepthXMLStreamReader)reader)) {
                            throw new Fault(new org.apache.cxf.common.i18n.Message("EXPECTED_ELEMENT_IN_PART", BUNDLE, new Object[0]));
                        }
                    }
                    parameters.put(part, dr.read(part, (Object)reader));
                    if (!part.isElement()) continue;
                    reader.next();
                }
                int ev = reader.getEventType();
                while (ev != 2 && ev != 1 && ev != 8) {
                    ev = reader.next();
                }
            }
            message.setContent(List.class, (Object)parameters);
        }
        catch (XMLStreamException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_READ_EXC", BUNDLE, new Object[0]), (Throwable)e);
        }
    }

    private void readJBIWrapper(DepthXMLStreamReader reader) throws XMLStreamException {
        if (!StaxUtils.skipToStartOfElement((DepthXMLStreamReader)reader)) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NOT_ENOUGH_PARTS", BUNDLE, new Object[0]));
        }
        QName startQName = reader.getName();
        if (!startQName.equals(JBIConstants.JBI_WRAPPER_PART)) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_JBI_PART_ELEMENT", BUNDLE, new Object[0]));
        }
    }

    private MessageInfo setMessage(Message message, BindingOperationInfo operation, boolean requestor, ServiceInfo si) {
        MessageInfo msgInfo = this.getMessageInfo(message, operation, requestor);
        message.put(MessageInfo.class, (Object)msgInfo);
        message.getExchange().put(BindingOperationInfo.class, (Object)operation);
        message.getExchange().put(OperationInfo.class, (Object)operation.getOperationInfo());
        message.getExchange().setOneWay(operation.getOperationInfo().isOneWay());
        message.put((Object)"javax.xml.ws.wsdl.operation", (Object)operation.getName());
        QName serviceQName = si.getName();
        message.put((Object)"javax.xml.ws.wsdl.service", (Object)serviceQName);
        QName interfaceQName = si.getInterface().getName();
        message.put((Object)"javax.xml.ws.wsdl.interface", (Object)interfaceQName);
        EndpointInfo endpointInfo = ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo();
        QName portQName = endpointInfo.getName();
        message.put((Object)"javax.xml.ws.wsdl.port", (Object)portQName);
        String address = endpointInfo.getAddress();
        URI wsdlDescription = null;
        try {
            wsdlDescription = new URI(address + "?wsdl");
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        message.put((Object)"javax.xml.ws.wsdl.description", wsdlDescription);
        return msgInfo;
    }
}

