/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxf.transport.jbi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.NormalizedMessage;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.servicemix.cxf.transport.jbi.JBIConduit;
import org.apache.servicemix.cxf.transport.jbi.JBIMessageHelper;

public class JBIConduitOutputStream
extends CachedOutputStream {
    private static final Logger LOG = LogUtils.getL7dLogger(JBIConduitOutputStream.class);
    private Message message;
    private boolean isOneWay;
    private DeliveryChannel channel;
    private JBIConduit conduit;
    private EndpointReferenceType target;

    public JBIConduitOutputStream(Message m, DeliveryChannel channel, EndpointReferenceType target, JBIConduit conduit) {
        this.message = m;
        this.channel = channel;
        this.conduit = conduit;
        this.target = target;
    }

    protected void doFlush() throws IOException {
    }

    protected void doClose() throws IOException {
        this.isOneWay = this.message.getExchange().isOneWay();
        this.commitOutputMessage();
        if (this.target != null) {
            this.target.getClass();
        }
    }

    private void commitOutputMessage() throws IOException {
        try {
            Member member = (Member)this.message.get((Object)Method.class.getName());
            Class<?> clz = member.getDeclaringClass();
            Exchange exchange = this.message.getExchange();
            BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
            LOG.info(new org.apache.cxf.common.i18n.Message("INVOKE.SERVICE", LOG, new Object[0]).toString() + clz);
            WebService ws = clz.getAnnotation(WebService.class);
            assert (ws != null);
            QName interfaceName = new QName(ws.targetNamespace(), ws.name());
            QName serviceName = null;
            serviceName = this.target != null ? EndpointReferenceUtils.getServiceName((EndpointReferenceType)this.target, (Bus)((Bus)this.message.getExchange().get(Bus.class))) : ((Service)this.message.getExchange().get(Service.class)).getName();
            MessageExchangeFactory factory = this.channel.createExchangeFactoryForService(serviceName);
            LOG.info(new org.apache.cxf.common.i18n.Message("CREATE.MESSAGE.EXCHANGE", LOG, new Object[0]).toString() + serviceName);
            Object xchng = null;
            xchng = this.isOneWay ? factory.createInOnlyExchange() : (bop.getOutput() == null ? factory.createRobustInOnlyExchange() : factory.createInOutExchange());
            NormalizedMessage inMsg = xchng.createMessage();
            LOG.info(new org.apache.cxf.common.i18n.Message("EXCHANGE.ENDPOINT", LOG, new Object[0]).toString() + xchng.getEndpoint());
            if (inMsg != null) {
                LOG.info("setup message contents on " + inMsg);
                inMsg.setContent(this.getMessageContent(this.message));
                xchng.setService(serviceName);
                LOG.info("service for exchange " + serviceName);
                xchng.setInterfaceName(interfaceName);
                xchng.setOperation(bop.getName());
                Map invocationContext = CastUtils.cast((Map)((Map)this.message.get((Object)"org.apache.cxf.invocation.context")));
                if (invocationContext != null) {
                    for (Map.Entry ent : CastUtils.cast((Map)((Map)invocationContext.get("RequestContext")), String.class, Object.class).entrySet()) {
                        if (!(ent.getValue() instanceof Serializable) || ent.getValue() instanceof Map || ent.getValue() instanceof Collection) continue;
                        inMsg.setProperty((String)ent.getKey(), ent.getValue());
                    }
                }
                xchng.setMessage(inMsg, "in");
                LOG.info("sending message");
                if (!this.isOneWay) {
                    this.channel.sendSync((MessageExchange)xchng);
                    NormalizedMessage outMsg = ((InOut)xchng).getOutMessage();
                    Source content = null;
                    Set normalizedMessageProps = null;
                    if (outMsg != null) {
                        content = outMsg.getContent();
                        normalizedMessageProps = outMsg.getPropertyNames();
                    } else {
                        if (((InOut)xchng).getFault() == null) {
                            throw xchng.getError();
                        }
                        content = ((InOut)xchng).getFault().getContent();
                        normalizedMessageProps = ((InOut)xchng).getFault().getPropertyNames();
                    }
                    MessageImpl inMessage = new MessageImpl();
                    this.message.getExchange().setInMessage((Message)inMessage);
                    InputStream ins = JBIMessageHelper.convertMessageToInputStream(content);
                    if (ins == null) {
                        throw new IOException(new org.apache.cxf.common.i18n.Message("UNABLE.RETRIEVE.MESSAGE", LOG, new Object[0]).toString());
                    }
                    inMessage.setContent(InputStream.class, (Object)ins);
                    inMessage.put(MessageExchange.class, xchng);
                    if (normalizedMessageProps != null) {
                        for (Object name : normalizedMessageProps) {
                            inMessage.put((Object)((String)name), outMsg.getProperty((String)name));
                        }
                    }
                    this.conduit.getMessageObserver().onMessage((Message)inMessage);
                    xchng.setStatus(ExchangeStatus.DONE);
                    this.channel.send((MessageExchange)xchng);
                } else {
                    this.channel.send((MessageExchange)xchng);
                }
            } else {
                LOG.info(new org.apache.cxf.common.i18n.Message("NO.MESSAGE", LOG, new Object[0]).toString());
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    private Source getMessageContent(Message message2) throws IOException {
        return new StreamSource(this.getInputStream());
    }

    protected void onWrite() throws IOException {
    }
}

