/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.xml.MessageReader;

public abstract class AbstractMessageReader
implements MessageReader {
    private static final QName XSI_NIL = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi");

    public void readToEnd() {
        this.readToEnd(this);
    }

    private void readToEnd(MessageReader childReader) {
        while (childReader.hasMoreElementReaders()) {
            this.readToEnd(childReader.getNextElementReader());
        }
    }

    public boolean isXsiNil() {
        String value;
        MessageReader nilReader = this.getAttributeReader(XSI_NIL);
        boolean nil = false;
        if (nilReader != null && (value = nilReader.getValue()) != null && (value.trim().equals("true") || value.trim().equals("1"))) {
            return true;
        }
        return nil;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    public char getValueAsCharacter() {
        if (this.getValue() == null) {
            return '\u0000';
        }
        return this.getValue().charAt(0);
    }

    public int getValueAsInt() {
        if (this.getValue() == null) {
            return 0;
        }
        return Integer.parseInt(this.getValue().trim());
    }

    public long getValueAsLong() {
        if (this.getValue() == null) {
            return 0L;
        }
        return Long.parseLong(this.getValue().trim());
    }

    public double getValueAsDouble() {
        if (this.getValue() == null) {
            return 0.0;
        }
        return Double.parseDouble(this.getValue().trim());
    }

    public float getValueAsFloat() {
        if (this.getValue() == null) {
            return 0.0f;
        }
        return Float.parseFloat(this.getValue().trim());
    }

    public boolean getValueAsBoolean() {
        String value = this.getValue();
        if (value == null) {
            return false;
        }
        if ("true".equalsIgnoreCase(value = value.trim()) || "1".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value)) {
            return false;
        }
        throw new DatabindingException("Invalid boolean value: " + value);
    }

    public XMLStreamReader getXMLStreamReader() {
        throw new UnsupportedOperationException();
    }
}

