/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfse;

import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceRef;
import org.apache.cxf.Bus;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.ServiceImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.jbi.JBIDestination;
import org.apache.cxf.transport.jbi.JBIDispatcherUtil;
import org.apache.cxf.transport.jbi.JBITransportFactory;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.cxfse.CxfSeComponent;
import org.apache.servicemix.cxfse.support.ReflectionUtils;
import org.apache.servicemix.id.IdGenerator;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfSeEndpoint
extends ProviderEndpoint
implements InterceptorProvider {
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    private Object pojo;
    private EndpointImpl endpoint;
    private String address;
    private List<Interceptor> in = new CopyOnWriteArrayList<Interceptor>();
    private List<Interceptor> out = new CopyOnWriteArrayList<Interceptor>();
    private List<Interceptor> outFault = new CopyOnWriteArrayList<Interceptor>();
    private List<Interceptor> inFault = new CopyOnWriteArrayList<Interceptor>();

    public Object getPojo() {
        return this.pojo;
    }

    public void setPojo(Object pojo) {
        this.pojo = pojo;
    }

    public List<Interceptor> getOutFaultInterceptors() {
        return this.outFault;
    }

    public List<Interceptor> getInFaultInterceptors() {
        return this.inFault;
    }

    public List<Interceptor> getInInterceptors() {
        return this.in;
    }

    public List<Interceptor> getOutInterceptors() {
        return this.out;
    }

    public void setInInterceptors(List<Interceptor> interceptors) {
        this.in = interceptors;
    }

    public void setInFaultInterceptors(List<Interceptor> interceptors) {
        this.inFault = interceptors;
    }

    public void setOutInterceptors(List<Interceptor> interceptors) {
        this.out = interceptors;
    }

    public void setOutFaultInterceptors(List<Interceptor> interceptors) {
        this.outFault = interceptors;
    }

    public void validate() throws DeploymentException {
        if (this.getPojo() == null) {
            throw new DeploymentException("pojo must be set");
        }
        JaxWsServiceFactoryBean serviceFactory = new JaxWsServiceFactoryBean();
        serviceFactory.setPopulateFromClass(true);
        this.endpoint = new EndpointImpl(this.getBus(), this.getPojo(), new JaxWsServerFactoryBean(serviceFactory));
        this.endpoint.setBindingUri("http://cxf.apache.org/bindings/jbi");
        this.endpoint.setInInterceptors(this.getInInterceptors());
        this.endpoint.setInFaultInterceptors(this.getInFaultInterceptors());
        this.endpoint.setOutInterceptors(this.getOutInterceptors());
        this.endpoint.setOutFaultInterceptors(this.getOutFaultInterceptors());
        JaxWsImplementorInfo implInfo = new JaxWsImplementorInfo(this.getPojo().getClass());
        this.setService(implInfo.getServiceName());
        this.setInterfaceName(implInfo.getInterfaceName());
        this.setEndpoint(implInfo.getEndpointName().getLocalPart());
        super.validate();
    }

    public void process(MessageExchange exchange) throws Exception {
        JBITransportFactory jbiTransportFactory = (JBITransportFactory)((ConduitInitiatorManager)this.getBus().getExtension(ConduitInitiatorManager.class)).getConduitInitiator("http://cxf.apache.org/transports/jbi");
        JBIDestination jbiDestination = jbiTransportFactory.getDestination(exchange.getService().toString() + exchange.getInterfaceName().toString());
        DeliveryChannel dc = this.getContext().getDeliveryChannel();
        jbiDestination.setDeliveryChannel(dc);
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            jbiDestination.getJBIDispatcherUtil().dispatch(exchange);
        }
    }

    public void start() throws Exception {
        super.start();
        this.address = "jbi://" + ID_GENERATOR.generateSanitizedId();
        this.endpoint.publish(this.address);
        this.setService(this.endpoint.getServer().getEndpoint().getService().getName());
        this.setEndpoint(this.endpoint.getServer().getEndpoint().getEndpointInfo().getName().getLocalPart());
        try {
            this.definition = new ServiceWSDLBuilder(this.getBus(), new ServiceInfo[]{(ServiceInfo)this.endpoint.getServer().getEndpoint().getService().getServiceInfos().iterator().next()}).build();
        }
        catch (WSDLException e) {
            throw new DeploymentException((Throwable)e);
        }
        ReflectionUtils.doWithFields(this.getPojo().getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                if (field.getAnnotation(WebServiceRef.class) != null) {
                    ServiceImpl s = new ServiceImpl(CxfSeEndpoint.this.getBus(), null, null, field.getType());
                    s.addPort(new QName("port"), "http://cxf.apache.org/transports/jbi", "jbi://" + ID_GENERATOR.generateSanitizedId());
                    Object o = s.getPort(new QName("port"), field.getType());
                    field.setAccessible(true);
                    field.set(CxfSeEndpoint.this.getPojo(), o);
                }
            }
        });
        ReflectionUtils.callLifecycleMethod(this.getPojo(), PostConstruct.class);
    }

    public void stop() throws Exception {
        ReflectionUtils.callLifecycleMethod(this.getPojo(), PreDestroy.class);
        JBIDispatcherUtil.clean();
        this.getBus().shutdown(true);
        super.stop();
    }

    protected Bus getBus() {
        return ((CxfSeComponent)this.getServiceUnit().getComponent()).getBus();
    }
}

