/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.cxf.service.model.AbstractDescriptionElement;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.ws.commons.schema.XmlSchemaCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceInfo
extends AbstractDescriptionElement {
    QName name;
    String targetNamespace;
    InterfaceInfo intf;
    Map<QName, BindingInfo> bindings = new ConcurrentHashMap<QName, BindingInfo>(2);
    Map<QName, EndpointInfo> endpoints = new ConcurrentHashMap<QName, EndpointInfo>(2);
    Map<QName, MessageInfo> messages;
    List<SchemaInfo> schemas = new ArrayList<SchemaInfo>(4);
    private XmlSchemaCollection xmlSchemaCollection;

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String ns) {
        this.targetNamespace = ns;
    }

    public void setName(QName n) {
        this.name = n;
    }

    public QName getName() {
        return this.name;
    }

    public InterfaceInfo createInterface(QName qn) {
        this.intf = new InterfaceInfo(this, qn);
        return this.intf;
    }

    public void setInterface(InterfaceInfo inf) {
        this.intf = inf;
    }

    public InterfaceInfo getInterface() {
        return this.intf;
    }

    public BindingInfo getBinding(QName qn) {
        return this.bindings.get(qn);
    }

    public void addBinding(BindingInfo binding) {
        this.bindings.put(binding.getName(), binding);
    }

    public EndpointInfo getEndpoint(QName qn) {
        return this.endpoints.get(qn);
    }

    public void addEndpoint(EndpointInfo ep) {
        this.endpoints.put(ep.getName(), ep);
    }

    public Collection<EndpointInfo> getEndpoints() {
        return Collections.unmodifiableCollection(this.endpoints.values());
    }

    public Collection<BindingInfo> getBindings() {
        return Collections.unmodifiableCollection(this.bindings.values());
    }

    public Map<QName, MessageInfo> getMessages() {
        if (this.messages == null) {
            this.initMessagesMap();
        }
        return this.messages;
    }

    public MessageInfo getMessage(QName qname) {
        return this.getMessages().get(qname);
    }

    private void initMessagesMap() {
        this.messages = new ConcurrentHashMap<QName, MessageInfo>();
        for (OperationInfo operation : this.getInterface().getOperations()) {
            if (operation.getInput() != null) {
                this.messages.put(operation.getInput().getName(), operation.getInput());
            }
            if (operation.getOutput() == null) continue;
            this.messages.put(operation.getOutput().getName(), operation.getOutput());
        }
    }

    public void setMessages(Map<QName, MessageInfo> msgs) {
        this.messages = msgs;
    }

    public void refresh() {
        this.initMessagesMap();
    }

    public void addSchema(SchemaInfo schemaInfo) {
        this.schemas.add(schemaInfo);
    }

    public SchemaInfo getSchema(String namespaceURI) {
        for (SchemaInfo s : this.schemas) {
            if (!(namespaceURI != null ? namespaceURI.equals(s.getNamespaceURI()) : s.getNamespaceURI() == null)) continue;
            return s;
        }
        return null;
    }

    public Collection<SchemaInfo> getSchemas() {
        return Collections.unmodifiableCollection(this.schemas);
    }

    public void setXmlSchemaCollection(XmlSchemaCollection col) {
        this.xmlSchemaCollection = col;
    }

    public XmlSchemaCollection getXmlSchemaCollection() {
        return this.xmlSchemaCollection;
    }
}

