/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(LoggingInInterceptor.class);

    public LoggingInInterceptor() {
        super("receive");
    }

    public void handleMessage(Message message) throws Fault {
        if (LOG.isLoggable(Level.INFO)) {
            InputStream is;
            Object headers;
            StringBuffer buffer = new StringBuffer("Inbound Message\n--------------------------------------");
            String encoding = (String)message.get((Object)Message.ENCODING);
            if (encoding != null) {
                buffer.append("\nEncoding: " + encoding);
            }
            if ((headers = message.get((Object)Message.PROTOCOL_HEADERS)) != null) {
                buffer.append("\nHeaders: " + headers);
            }
            if ((is = (InputStream)message.getContent(InputStream.class)) != null) {
                CachedOutputStream bos = new CachedOutputStream();
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)bos);
                    is.close();
                    bos.close();
                    buffer.append("\nMessage:\n");
                    buffer.append(bos.getOut().toString());
                    message.setContent(InputStream.class, (Object)bos.getInputStream());
                }
                catch (IOException e) {
                    throw new Fault((Throwable)e);
                }
            }
            buffer.append("\n--------------------------------------");
            LOG.info(buffer.toString());
        }
    }
}

