/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProviderInDatabindingInterceptor
extends AbstractInDatabindingInterceptor {
    private Class type;

    public ProviderInDatabindingInterceptor(Class type) {
        super("pre-stream");
        this.type = type;
    }

    public Class getType() {
        return this.type;
    }

    public void handleMessage(Message message) throws Fault {
        Exchange ex = message.getExchange();
        Endpoint e = (Endpoint)ex.get(Endpoint.class);
        if (e.getEndpointInfo().getBinding().getOperations().iterator().hasNext()) {
            BindingOperationInfo bop = (BindingOperationInfo)e.getEndpointInfo().getBinding().getOperations().iterator().next();
            ex.put(BindingOperationInfo.class, (Object)bop);
            this.getMessageInfo(message, bop);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        if (this.isGET(message)) {
            params.add(null);
            message.setContent(Object.class, params);
            return;
        }
        Service s = (Service)ex.get(Service.class);
        if (SOAPMessage.class.equals((Object)this.type)) {
            SOAPMessage msg = (SOAPMessage)message.getContent(SOAPMessage.class);
            params.add(msg);
        } else if (DataSource.class.equals((Object)this.type)) {
            InputStream is = (InputStream)message.getContent(InputStream.class);
            try {
                params.add(new ByteArrayDataSource(is, (String)message.get((Object)"Content-Type")));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            XMLStreamReader r = (XMLStreamReader)message.getContent(XMLStreamReader.class);
            if (r != null) {
                if (r instanceof W3CDOMStreamReader) {
                    Element nd = ((W3CDOMStreamReader)r).getCurrentElement();
                    DataReader reader = s.getDataBinding().createReader(Node.class);
                    Object object = reader.read(null, (Object)nd, this.type);
                    params.add(object);
                } else {
                    DataReader reader = s.getDataBinding().createReader(XMLStreamReader.class);
                    Object object = reader.read(null, (Object)r, this.type);
                    params.add(object);
                }
            }
        }
        message.setContent(Object.class, params);
    }
}

