/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.catalog;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.wsdl.xml.WSDLLocator;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.resource.ExtendedURIResolver;
import org.apache.xml.resolver.Catalog;
import org.xml.sax.InputSource;

public class CatalogWSDLLocator
implements WSDLLocator {
    private String wsdlUrl;
    private ExtendedURIResolver resolver;
    private Catalog catalogResolver;
    private String baseUri;

    public CatalogWSDLLocator(String wsdlUrl, OASISCatalogManager catalogManager) {
        this.baseUri = this.wsdlUrl = wsdlUrl;
        this.catalogResolver = catalogManager.getCatalog();
        this.resolver = new ExtendedURIResolver();
    }

    public InputSource getBaseInputSource() {
        InputSource result = this.resolver.resolve(this.baseUri, null);
        if (result == null) {
            try {
                String s = this.catalogResolver.resolveSystem(this.baseUri);
                if (s != null) {
                    result = this.resolver.resolve(s, null);
                }
            }
            catch (MalformedURLException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.baseUri = this.resolver.getURI();
        return result;
    }

    public String getBaseURI() {
        return this.getBaseInputSource().getSystemId();
    }

    public String getLatestImportURI() {
        return this.resolver.getLatestImportURI();
    }

    public InputSource getImportInputSource(String parent, String importLocation) {
        this.baseUri = parent;
        String resolvedImportLocation = null;
        try {
            resolvedImportLocation = this.catalogResolver.resolveSystem(importLocation);
        }
        catch (IOException e) {
            throw new RuntimeException("Catalog resolution failed", e);
        }
        InputSource in = null;
        in = resolvedImportLocation == null ? this.resolver.resolve(importLocation, this.baseUri) : this.resolver.resolve(resolvedImportLocation, null);
        if (in == null) {
            in = new InputSource();
        }
        return in;
    }

    public void close() {
        this.resolver.close();
    }
}

