/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInvoker
implements Invoker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Exchange exchange, Object o) {
        Object serviceObject = this.getServiceObject(exchange);
        try {
            BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
            MethodDispatcher md = (MethodDispatcher)((Service)exchange.get(Service.class)).get((Object)MethodDispatcher.class.getName());
            Method m = md.getMethod(bop);
            m = AbstractInvoker.matchMethod(m, serviceObject);
            List params = null;
            if (o instanceof List) {
                params = CastUtils.cast((List)((List)o));
            } else if (o != null) {
                params = new MessageContentsList(new Object[]{o});
            }
            Object object = this.invoke(exchange, serviceObject, m, params);
            return object;
        }
        finally {
            this.releaseServiceObject(exchange, serviceObject);
        }
    }

    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        try {
            Object[] paramArray = new Object[]{};
            if (params != null) {
                paramArray = params.toArray();
            }
            Object res = this.performInvocation(exchange, serviceObject, m, paramArray);
            if (exchange.isOneWay()) {
                return null;
            }
            return new MessageContentsList(new Object[]{res});
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t == null) {
                t = e;
            }
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.CHECKED_APPLICATION_FAULT);
            throw this.createFault(t);
        }
        catch (Fault f) {
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw f;
        }
        catch (Exception e) {
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw this.createFault(e);
        }
    }

    protected Fault createFault(Throwable ex) {
        return new Fault(ex);
    }

    protected Object performInvocation(Exchange exchange, Object serviceObject, Method m, Object[] paramArray) throws Exception {
        paramArray = this.insertExchange(m, paramArray, exchange);
        return m.invoke(serviceObject, paramArray);
    }

    public Object[] insertExchange(Method method, Object[] params, Exchange context) {
        Object[] newParams = params;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (!method.getParameterTypes()[i].equals(Exchange.class)) continue;
            newParams = new Object[params.length + 1];
            for (int j = 0; j < newParams.length; ++j) {
                newParams[j] = j == i ? context : (j > i ? params[j - 1] : params[j]);
            }
        }
        return newParams;
    }

    public abstract Object getServiceObject(Exchange var1);

    public void releaseServiceObject(Exchange context, Object obj) {
    }

    private static Method matchMethod(Method methodToMatch, Object targetObject) {
        if (AbstractInvoker.isJdkDynamicProxy(targetObject)) {
            Class<?>[] interfaces = targetObject.getClass().getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method m = AbstractInvoker.getMostSpecificMethod(methodToMatch, interfaces[i]);
                if (methodToMatch.equals(m)) continue;
                return m;
            }
        }
        return methodToMatch;
    }

    public static boolean isJdkDynamicProxy(Object object) {
        return object != null && Proxy.isProxyClass(object.getClass());
    }

    public static Method getMostSpecificMethod(Method method, Class<?> targetClass) {
        if (method != null && targetClass != null) {
            try {
                method = targetClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }
}

