/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.activation.DataSource;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;

public class ProviderOutDatabindingInterceptor
extends AbstractInDatabindingInterceptor {
    public ProviderOutDatabindingInterceptor() {
        super("marshal");
    }

    public ProviderOutDatabindingInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        Service s = (Service)message.getExchange().get(Service.class);
        XMLStreamWriter xsw = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        DataWriter writer = s.getDataBinding().createWriter(XMLStreamWriter.class);
        List objs = (List)message.getContent(List.class);
        for (Object o : objs) {
            if (o == null) continue;
            if (o instanceof SOAPMessage) {
                message.setContent(SOAPMessage.class, o);
                continue;
            }
            if (o instanceof DataSource) {
                try {
                    message.removeContent(XMLStreamWriter.class);
                    OutputStream out = (OutputStream)message.getContent(OutputStream.class);
                    IOUtils.copy((InputStream)((DataSource)o).getInputStream(), (OutputStream)out);
                    continue;
                }
                catch (IOException ex) {
                    throw new Fault((Throwable)ex);
                }
            }
            writer.write(o, (Object)xsw);
        }
    }
}

