/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.resource;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.resource.ClassLoaderResolver;
import org.apache.cxf.resource.ClasspathResolver;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceManager
implements ResourceManager {
    private static final Logger LOG = LogUtils.getL7dLogger(DefaultResourceManager.class);
    protected final List<ResourceResolver> registeredResolvers = new CopyOnWriteArrayList<ResourceResolver>();

    public DefaultResourceManager() {
        this.initializeDefaultResolvers();
    }

    public DefaultResourceManager(ResourceResolver resolver) {
        this.addResourceResolver(resolver);
    }

    public DefaultResourceManager(List<ResourceResolver> resolvers) {
        this.registeredResolvers.addAll(resolvers);
    }

    @Override
    public final <T> T resolveResource(String name, Class<T> type) {
        return this.findResource(name, type, false, this.registeredResolvers);
    }

    @Override
    public final <T> T resolveResource(String name, Class<T> type, List<ResourceResolver> resolvers) {
        return this.findResource(name, type, false, resolvers);
    }

    @Override
    public final InputStream getResourceAsStream(String name) {
        return this.findResource(name, InputStream.class, true, this.registeredResolvers);
    }

    @Override
    public final void addResourceResolver(ResourceResolver resolver) {
        if (!this.registeredResolvers.contains(resolver)) {
            this.registeredResolvers.add(0, resolver);
        }
    }

    @Override
    public final void removeResourceResolver(ResourceResolver resolver) {
        if (this.registeredResolvers.contains(resolver)) {
            this.registeredResolvers.remove(resolver);
        }
    }

    @Override
    public final List<ResourceResolver> getResourceResolvers() {
        return Collections.unmodifiableList(this.registeredResolvers);
    }

    private <T> T findResource(String name, Class<T> type, boolean asStream, List<ResourceResolver> resolvers) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("resolving resource <" + name + ">" + (asStream ? " as stream " : " type <" + type + ">"));
        }
        T ret = null;
        for (ResourceResolver rr : resolvers) {
            ret = asStream ? (T)type.cast(rr.getAsStream(name)) : (T)rr.resolve(name, type);
            if (ret == null) continue;
            break;
        }
        return ret;
    }

    private void initializeDefaultResolvers() {
        this.addResourceResolver(new ClasspathResolver());
        this.addResourceResolver(new ClassLoaderResolver(this.getClass().getClassLoader()));
    }
}

