/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.cfg.OutputConfigFlags;
import com.ctc.wstx.exc.WstxIOException;
import com.ctc.wstx.io.CharsetNames;
import com.ctc.wstx.io.UTF8Writer;
import com.ctc.wstx.sw.BaseStreamWriter;
import com.ctc.wstx.sw.BufferingXmlWriter;
import com.ctc.wstx.sw.ISOLatin1XmlWriter;
import com.ctc.wstx.sw.NonNsStreamWriter;
import com.ctc.wstx.sw.RepairingNsStreamWriter;
import com.ctc.wstx.sw.SimpleNsStreamWriter;
import com.ctc.wstx.sw.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.stax2.io.Stax2Result;

public final class MinimalOutputFactory
implements OutputConfigFlags {
    protected final boolean mIsMinimal;
    protected final WriterConfig mConfig;

    protected MinimalOutputFactory(boolean isMinimal) {
        this.mIsMinimal = isMinimal;
        this.mConfig = WriterConfig.createJ2MEDefaults();
    }

    public static MinimalOutputFactory newMinimalInstance() {
        return new MinimalOutputFactory(true);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream out) throws XMLStreamException {
        return this.createSW(out, null, null, false);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream out, String enc) throws XMLStreamException {
        return this.createSW(out, null, enc, false);
    }

    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        return this.createSW(result);
    }

    public XMLStreamWriter createXMLStreamWriter(Writer w) throws XMLStreamException {
        return this.createSW(null, w, null, false);
    }

    public XMLStreamWriter createXMLStreamWriter(Writer w, String enc) throws XMLStreamException {
        return this.createSW(null, w, enc, false);
    }

    public Object getProperty(String name) {
        return this.mConfig.getProperty(name);
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public void setProperty(String name, Object value) {
        this.mConfig.setProperty(name, value);
    }

    public WriterConfig getConfig() {
        return this.mConfig;
    }

    /*
     * WARNING - void declaration
     */
    private BaseStreamWriter createSW(OutputStream out, Writer w, String enc, boolean autoCloseOutput) throws XMLStreamException {
        void var6_6;
        XmlWriter xw;
        WriterConfig cfg = this.mConfig.createNonShared();
        if (w == null) {
            enc = enc == null ? "UTF-8" : CharsetNames.normalize(enc);
            try {
                if (enc == "UTF-8") {
                    w = new UTF8Writer(cfg, out, autoCloseOutput);
                    xw = new BufferingXmlWriter(w, cfg, enc, true);
                }
                if (enc == "ISO-8859-1") {
                    xw = new ISOLatin1XmlWriter(out, cfg, autoCloseOutput);
                }
                if (enc == "US-ASCII") {
                    xw = new ISOLatin1XmlWriter(out, cfg, autoCloseOutput);
                }
                w = new OutputStreamWriter(out, enc);
                xw = new BufferingXmlWriter(w, cfg, enc, autoCloseOutput);
            }
            catch (IOException ex) {
                throw new XMLStreamException(ex);
            }
        } else {
            if (enc == null && w instanceof OutputStreamWriter) {
                enc = ((OutputStreamWriter)w).getEncoding();
            }
            try {
                xw = new BufferingXmlWriter(w, cfg, enc, autoCloseOutput);
            }
            catch (IOException ex) {
                throw new XMLStreamException(ex);
            }
        }
        if (cfg.willSupportNamespaces()) {
            if (cfg.automaticNamespacesEnabled()) {
                return new RepairingNsStreamWriter((XmlWriter)var6_6, enc, cfg);
            }
            return new SimpleNsStreamWriter((XmlWriter)var6_6, enc, cfg);
        }
        return new NonNsStreamWriter((XmlWriter)var6_6, enc, cfg);
    }

    /*
     * WARNING - void declaration
     */
    private BaseStreamWriter createSW(Result res) throws XMLStreamException {
        void var5_8;
        boolean autoclose;
        OutputStream out = null;
        Writer w = null;
        String encoding = null;
        if (res instanceof Stax2Result) {
            Stax2Result sr = (Stax2Result)res;
            try {
                out = sr.constructOutputStream();
                if (out == null) {
                    w = sr.constructWriter();
                }
            }
            catch (IOException ioe) {
                throw new WstxIOException(ioe);
            }
            autoclose = true;
        } else if (res instanceof StreamResult) {
            StreamResult sr = (StreamResult)res;
            out = sr.getOutputStream();
            if (out == null) {
                w = sr.getWriter();
            }
            autoclose = false;
        } else {
            if (res instanceof SAXResult) {
                throw new XMLStreamException("Can not create a STaX writer for a SAXResult -- not implemented.");
            }
            if (res instanceof DOMResult) {
                throw new XMLStreamException("Can not create a STaX writer for a DOMResult -- not (yet?) implemented.");
            }
            throw new IllegalArgumentException("Can not instantiate a writer for XML result type " + res.getClass() + " (unrecognized type)");
        }
        if (out != null) {
            return this.createSW(out, null, encoding, (boolean)var5_8);
        }
        if (w != null) {
            return this.createSW(null, w, encoding, (boolean)var5_8);
        }
        throw new XMLStreamException("Can not create StAX writer for passed-in Result -- neither writer nor output stream was accessible");
    }
}

