/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.model;

import javax.xml.namespace.QName;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.w3c.dom.Element;

public final class SchemaInfo
extends AbstractPropertiesHolder {
    ServiceInfo serviceInfo;
    String namespaceUri;
    Element element;
    boolean isElementQualified;
    boolean isAttributeQualified;
    XmlSchema schema;
    String systemId;

    public SchemaInfo(ServiceInfo serviceInfo, String namespaceUri) {
        this.serviceInfo = serviceInfo;
        this.namespaceUri = namespaceUri;
        this.isElementQualified = false;
        this.isAttributeQualified = false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append(" [namespaceURI: ");
        buffer.append(this.namespaceUri);
        buffer.append("] [systemId: ");
        buffer.append(this.systemId);
        buffer.append("]");
        return buffer.toString();
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public String getNamespaceURI() {
        return this.namespaceUri;
    }

    public void setNamespaceURI(String nsUri) {
        this.namespaceUri = nsUri;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
        String form = element.getAttribute("elementFormDefault");
        if (form != null && form.equals("qualified")) {
            this.isElementQualified = true;
        }
        if ((form = element.getAttribute("attributeFormDefault")) != null && form.equals("qualified")) {
            this.isAttributeQualified = true;
        }
    }

    public boolean isElementFormQualified() {
        return this.isElementQualified;
    }

    public boolean isAttributeFormQualified() {
        return this.isAttributeQualified;
    }

    public XmlSchema getSchema() {
        return this.schema;
    }

    public void setSchema(XmlSchema schema) {
        this.schema = schema;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public XmlSchemaElement getElementByQName(QName qname) {
        String uri = qname.getNamespaceURI();
        if (this.schema != null && this.schema.getTargetNamespace() != null && this.schema.getTargetNamespace().equals(uri)) {
            return this.schema.getElementByName(qname);
        }
        return null;
    }
}

