/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Service;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.source.NodeDataReader;
import org.apache.cxf.databinding.source.XMLStreamDataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxws.handler.logical.DispatchLogicalHandlerInterceptor;
import org.apache.cxf.jaxws.handler.soap.DispatchSOAPHandlerInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.XMLMessage;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Node;

public class DispatchInDatabindingInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(DispatchInDatabindingInterceptor.class);
    private Class type;
    private Service.Mode mode;

    public DispatchInDatabindingInterceptor(Class type, Service.Mode mode) {
        super("read");
        this.type = type;
        this.mode = mode;
    }

    public void handleMessage(Message message) throws Fault {
        Exchange ex = message.getExchange();
        Endpoint ep = (Endpoint)ex.get(Endpoint.class);
        MessageInfo info = (MessageInfo)message.get(MessageInfo.class);
        if (ep.getEndpointInfo().getBinding().getOperations().iterator().hasNext()) {
            BindingOperationInfo bop = (BindingOperationInfo)ep.getEndpointInfo().getBinding().getOperations().iterator().next();
            ex.put(BindingOperationInfo.class, (Object)bop);
            info = this.getMessageInfo(message, bop);
        }
        if (this.isGET(message)) {
            MessageContentsList params = new MessageContentsList();
            if (info != null) {
                for (MessagePartInfo i : info.getMessageParts()) {
                    params.put(i, null);
                }
            } else {
                params.add(null);
            }
            message.setContent(List.class, (Object)params);
            LOG.info("DispatchInInterceptor skipped in HTTP GET method");
            return;
        }
        try {
            InputStream is = (InputStream)message.getContent(InputStream.class);
            Object obj = null;
            ex.put(Service.Mode.class, (Object)this.mode);
            if (message instanceof SoapMessage) {
                SOAPMessage soapMessage = this.newSOAPMessage(is, ((SoapMessage)message).getVersion());
                PostDispatchSOAPHandlerInterceptor postSoap = new PostDispatchSOAPHandlerInterceptor();
                message.getInterceptorChain().add((Interceptor)postSoap);
                message.setContent(SOAPMessage.class, (Object)soapMessage);
            } else if (message instanceof XMLMessage) {
                if (this.type.equals(DataSource.class)) {
                    try {
                        obj = new ByteArrayDataSource(is, (String)message.get((Object)"Content-Type"));
                    }
                    catch (IOException e) {
                        throw new Fault((Throwable)e);
                    }
                    message.setContent(DataSource.class, obj);
                } else {
                    new StaxInInterceptor().handleMessage(message);
                    XMLStreamDataReader dataReader = new XMLStreamDataReader();
                    Class<Source> readType = this.type;
                    if (!Source.class.isAssignableFrom(this.type)) {
                        readType = Source.class;
                    }
                    obj = dataReader.read(null, message.getContent(XMLStreamReader.class), readType);
                    message.setContent(Source.class, obj);
                }
            }
            PostDispatchLogicalHandlerInterceptor postLogical = new PostDispatchLogicalHandlerInterceptor();
            message.getInterceptorChain().add((Interceptor)postLogical);
            is.close();
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    private SOAPMessage newSOAPMessage(InputStream is, SoapVersion version) throws Exception {
        MimeHeaders headers = new MimeHeaders();
        MessageFactory msgFactory = null;
        if (version == null || version instanceof Soap11) {
            msgFactory = MessageFactory.newInstance();
        } else if (version instanceof Soap12) {
            msgFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        }
        return msgFactory.createMessage(headers, is);
    }

    private Object convertSourceToJaxb(Source source, Message message) throws Exception {
        CachedOutputStream cos = new CachedOutputStream();
        Transformer transformer = XMLUtils.newTransformer();
        transformer.transform(source, new StreamResult((OutputStream)cos));
        String encoding = (String)message.get((Object)Message.ENCODING);
        XMLStreamReader reader = null;
        reader = StaxUtils.getXMLInputFactory().createXMLStreamReader(cos.getInputStream(), encoding);
        DataReader dataReader = this.getDataReader(message);
        dataReader.setProperty("unwrap.jaxb.element", (Object)Boolean.FALSE);
        Object obj = dataReader.read(null, (Object)reader, null);
        return obj;
    }

    private class PostDispatchLogicalHandlerInterceptor
    extends AbstractInDatabindingInterceptor {
        public PostDispatchLogicalHandlerInterceptor() {
            super("user-logical");
            this.addAfter(DispatchLogicalHandlerInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            Object obj = null;
            if (message instanceof SoapMessage) {
                Source source = (Source)message.getContent(Source.class);
                message.removeContent(Source.class);
                if (SOAPMessage.class.isAssignableFrom(DispatchInDatabindingInterceptor.this.type)) {
                    try {
                        CachedOutputStream cos = new CachedOutputStream();
                        Transformer transformer = XMLUtils.newTransformer();
                        transformer.transform(source, new StreamResult((OutputStream)cos));
                        obj = DispatchInDatabindingInterceptor.this.newSOAPMessage(cos.getInputStream(), ((SoapMessage)message).getVersion());
                    }
                    catch (Exception e) {
                        throw new Fault((Throwable)e);
                    }
                } else if (Source.class.isAssignableFrom(DispatchInDatabindingInterceptor.this.type)) {
                    obj = source;
                } else {
                    try {
                        obj = DispatchInDatabindingInterceptor.this.convertSourceToJaxb(source, message);
                    }
                    catch (Exception e) {
                        throw new Fault((Throwable)e);
                    }
                }
            } else if (message instanceof XMLMessage) {
                Source source = (Source)message.getContent(Source.class);
                message.removeContent(Source.class);
                DataSource dataSource = (DataSource)message.getContent(DataSource.class);
                message.removeContent(DataSource.class);
                if (source != null) {
                    if (Source.class.isAssignableFrom(DispatchInDatabindingInterceptor.this.type)) {
                        obj = source;
                    } else {
                        try {
                            obj = DispatchInDatabindingInterceptor.this.convertSourceToJaxb(source, message);
                        }
                        catch (Exception e) {
                            throw new Fault((Throwable)e);
                        }
                    }
                } else if (dataSource != null && DataSource.class.isAssignableFrom(DispatchInDatabindingInterceptor.this.type)) {
                    obj = dataSource;
                }
            }
            message.setContent(Object.class, obj);
        }
    }

    private class PostDispatchSOAPHandlerInterceptor
    extends AbstractInDatabindingInterceptor {
        public PostDispatchSOAPHandlerInterceptor() {
            super("user-protocol");
            this.addAfter(DispatchSOAPHandlerInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            Object obj = null;
            if (message instanceof SoapMessage) {
                SOAPMessage soapMessage = (SOAPMessage)message.getContent(SOAPMessage.class);
                message.removeContent(SOAPMessage.class);
                NodeDataReader dataReader = new NodeDataReader();
                Object n = null;
                if (DispatchInDatabindingInterceptor.this.mode == Service.Mode.MESSAGE) {
                    try {
                        n = soapMessage.getSOAPPart();
                        soapMessage.getSOAPPart().getEnvelope();
                    }
                    catch (SOAPException e) {
                        throw new Fault((Throwable)e);
                    }
                }
                if (DispatchInDatabindingInterceptor.this.mode == Service.Mode.PAYLOAD) {
                    try {
                        n = DOMUtils.getChild((Node)soapMessage.getSOAPBody(), (int)1);
                    }
                    catch (SOAPException e) {
                        throw new Fault((Throwable)e);
                    }
                }
                Class<Source> tempType = DispatchInDatabindingInterceptor.this.type;
                if (!Source.class.isAssignableFrom(DispatchInDatabindingInterceptor.this.type)) {
                    tempType = Source.class;
                }
                obj = dataReader.read(null, n, tempType);
                message.setContent(Source.class, obj);
            }
        }
    }
}

