/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.bus.extension.DeferredMap;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DestinationFactoryManagerImpl
implements DestinationFactoryManager {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(DestinationFactoryManager.class);
    final Map<String, DestinationFactory> destinationFactories;
    Properties factoryNamespaceMappings;
    private Bus bus;

    public DestinationFactoryManagerImpl() {
        this.destinationFactories = new ConcurrentHashMap<String, DestinationFactory>();
    }

    public DestinationFactoryManagerImpl(Map<String, DestinationFactory> destinationFactories) {
        this.destinationFactories = destinationFactories;
    }

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension((Object)this, DestinationFactoryManager.class);
        }
    }

    public void registerDestinationFactory(String namespace, DestinationFactory factory) {
        this.destinationFactories.put(namespace, factory);
    }

    public void deregisterDestinationFactory(String namespace) {
        this.destinationFactories.remove(namespace);
    }

    public DestinationFactory getDestinationFactory(String namespace) throws BusException {
        DestinationFactory factory = this.destinationFactories.get(namespace);
        if (null == factory) {
            throw new BusException(new Message("NO_DEST_FACTORY", BUNDLE, new Object[]{namespace}));
        }
        return factory;
    }

    @PreDestroy
    public void shutdown() {
    }

    public DestinationFactory getDestinationFactoryForUri(String uri) {
        for (DestinationFactory df : this.destinationFactories.values()) {
            for (String prefix : df.getUriPrefixes()) {
                if (!uri.startsWith(prefix)) continue;
                return df;
            }
        }
        if (this.destinationFactories instanceof DeferredMap) {
            ((DeferredMap)this.destinationFactories).undefer();
            for (DestinationFactory df : this.destinationFactories.values()) {
                for (String prefix : df.getUriPrefixes()) {
                    if (!uri.startsWith(prefix)) continue;
                    return df;
                }
            }
        }
        return null;
    }
}

