/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.model;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.tools.common.model.DefaultValueWriter;
import org.apache.cxf.tools.common.model.JavaInterface;

public class JavaType {
    private static Map<String, String> typeMapping = new HashMap<String, String>();
    protected String name;
    protected String type;
    protected String className;
    protected String targetNamespace;
    protected Style style;
    protected boolean isHeader;
    private QName qname;
    private JavaInterface owner;
    private DefaultValueWriter dvw;

    public JavaType() {
    }

    public JavaType(String n, String t, String tns) {
        this.name = n;
        this.type = t;
        this.targetNamespace = tns;
        this.className = t;
    }

    public void setDefaultValueWriter(DefaultValueWriter w) {
        this.dvw = w;
    }

    public DefaultValueWriter getDefaultValueWriter() {
        return this.dvw;
    }

    public void setQName(QName qn) {
        this.qname = qn;
    }

    public QName getQName() {
        return this.qname;
    }

    public void setClassName(String clzName) {
        this.className = clzName;
    }

    public String getClassName() {
        return this.className;
    }

    public void writeDefaultValue(Writer writer, String indent, String opName, String varName) throws IOException {
        if (this.dvw != null) {
            this.dvw.writeDefaultValue(writer, indent, opName, varName);
        } else {
            writer.write(this.className);
            writer.write(32);
            writer.write(varName);
            writer.write(" = ");
            writer.write(this.getDefaultTypeValue());
            writer.write(";");
        }
    }

    protected String getDefaultTypeValue() {
        if (this.className.trim().endsWith("[]")) {
            return "new " + this.className.substring(0, this.className.length() - 2) + "[0]";
        }
        if (typeMapping.containsKey(this.className.trim())) {
            return typeMapping.get(this.className);
        }
        try {
            if (this.hasDefaultConstructor(Class.forName(this.className))) {
                return "new " + this.className + "()";
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return "null";
    }

    private boolean hasDefaultConstructor(Class clz) {
        Constructor<?>[] cons = clz.getConstructors();
        if (cons.length == 0) {
            return false;
        }
        for (int i = 0; i < cons.length; ++i) {
            if (cons[i].getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public void setTargetNamespace(String tns) {
        this.targetNamespace = tns;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getRawName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) {
        this.type = t;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style s) {
        this.style = s;
    }

    public boolean isIN() {
        return this.style == Style.IN;
    }

    public boolean isOUT() {
        return this.style == Style.OUT;
    }

    public boolean isINOUT() {
        return this.style == Style.INOUT;
    }

    public void setHeader(boolean header) {
        this.isHeader = header;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nName: ");
        sb.append(this.name);
        sb.append("\nType: ");
        sb.append(this.type);
        sb.append("\nClassName: ");
        sb.append(this.className);
        sb.append("\nTargetNamespace: ");
        sb.append(this.targetNamespace);
        sb.append("\nStyle: ");
        sb.append((Object)this.style);
        return sb.toString();
    }

    public JavaInterface getOwner() {
        return this.owner;
    }

    public void setOwner(JavaInterface intf) {
        this.owner = intf;
    }

    static {
        typeMapping.put("boolean", "false");
        typeMapping.put("int", "0");
        typeMapping.put("long", "0");
        typeMapping.put("short", "Short.parseShort(\"0\")");
        typeMapping.put("byte", "Byte.parseByte(\"0\")");
        typeMapping.put("float", "0.0f");
        typeMapping.put("double", "0.0");
        typeMapping.put("char", "0");
        typeMapping.put("java.lang.String", "\"\"");
        typeMapping.put("javax.xml.namespace.QName", "new javax.xml.namespace.QName(\"\", \"\")");
        typeMapping.put("java.net.URI", "new java.net.URI(\"\")");
        typeMapping.put("java.math.BigInteger", "new java.math.BigInteger(\"0\")");
        typeMapping.put("java.math.BigDecimal", "new java.math.BigDecimal(\"0\")");
        typeMapping.put("javax.xml.datatype.XMLGregorianCalendar", "null");
        typeMapping.put("javax.xml.datatype.Duration", "null");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        IN,
        OUT,
        INOUT;

    }
}

