/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JAXBContextInitializer
extends ServiceModelVisitor {
    private Set<Class<?>> classes;
    private Set<String> packages;

    public JAXBContextInitializer(ServiceInfo serviceInfo, Set<Class<?>> classes) {
        super(serviceInfo);
        this.classes = classes;
        this.packages = new HashSet<String>();
    }

    public void begin(MessagePartInfo part) {
        Class<?> genericType;
        Class<?> clazz = part.getTypeClass();
        if (clazz == null) {
            return;
        }
        boolean isFromWrapper = part.getMessageInfo().getOperation().isUnwrapped();
        if (isFromWrapper && clazz.isArray() && !Byte.TYPE.equals(clazz.getComponentType())) {
            clazz = clazz.getComponentType();
        }
        if ((genericType = (Class<?>)part.getProperty("generic.type")) != null) {
            boolean isList = Collection.class.isAssignableFrom(clazz);
            if (isFromWrapper) {
                if (genericType instanceof Class && ((Class)genericType).isArray()) {
                    Class cl2 = genericType;
                    if (cl2.isArray() && !Byte.TYPE.equals(cl2.getComponentType())) {
                        genericType = cl2.getComponentType();
                    }
                    this.addType(genericType);
                } else if (!isList) {
                    this.addType(genericType);
                }
            } else {
                this.addType(genericType);
            }
            if (isList && genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)((Object)genericType);
                if (pt.getActualTypeArguments().length > 0 && pt.getActualTypeArguments()[0] instanceof Class) {
                    Class<?> arrayCls = Array.newInstance((Class)pt.getActualTypeArguments()[0], 0).getClass();
                    clazz = arrayCls;
                    part.setTypeClass(clazz);
                    if (isFromWrapper) {
                        this.addType(clazz.getComponentType());
                    }
                } else if (pt.getActualTypeArguments().length > 0 && pt.getActualTypeArguments()[0] instanceof GenericArrayType) {
                    GenericArrayType gat = (GenericArrayType)pt.getActualTypeArguments()[0];
                    gat.getGenericComponentType();
                    Class<?> arrayCls = Array.newInstance((Class)gat.getGenericComponentType(), 0).getClass();
                    clazz = Array.newInstance(arrayCls, 0).getClass();
                    part.setTypeClass(clazz);
                    if (isFromWrapper) {
                        this.addType(clazz.getComponentType());
                    }
                }
            }
            if (isFromWrapper && isList) {
                clazz = null;
            }
        }
        if (clazz != null) {
            this.addClass(clazz);
        }
    }

    private void addType(Type cls) {
        if (cls instanceof Class) {
            this.addClass((Class)cls);
        } else if (cls instanceof ParameterizedType) {
            for (Type t2 : ((ParameterizedType)cls).getActualTypeArguments()) {
                this.addType(t2);
            }
        } else if (cls instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)cls;
            Class<?> ct = (Class<?>)gt.getGenericComponentType();
            ct = Array.newInstance(ct, 0).getClass();
            this.addClass(ct);
        }
    }

    private void addClass(Class<?> cls) {
        if (cls.isArray() && cls.getComponentType().isPrimitive()) {
            return;
        }
        if (Exception.class.isAssignableFrom(cls)) {
            for (Field f : cls.getDeclaredFields()) {
                this.addClass(f.getType());
            }
            this.addClass(String.class);
        } else if (null != (cls = JAXBUtils.getValidClass(cls))) {
            if (this.classes.contains(cls)) {
                return;
            }
            if (cls.isEnum()) {
                this.classes.add(cls);
            }
            this.classes.add(cls);
            this.walkReferences(cls);
            String pname = PackageUtils.getPackageName((Class)cls);
            if (!this.packages.contains(pname)) {
                this.packages.add(pname);
                String name = pname + ".ObjectFactory";
                try {
                    Class<?> ocls = Class.forName(name, false, cls.getClassLoader());
                    if (!this.classes.contains(ocls)) {
                        this.classes.add(ocls);
                    }
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
            }
        }
    }

    private void walkReferences(Class<?> cls) {
        Method[] methods;
        Field[] fields;
        if (cls.getName().startsWith("java.") || cls.getName().startsWith("javax.")) {
            return;
        }
        for (Field f : fields = cls.getFields()) {
            this.addType(f.getGenericType());
        }
        for (Method m : methods = cls.getMethods()) {
            this.addType(m.getGenericReturnType());
            for (Type t : m.getGenericParameterTypes()) {
                this.addType(t);
            }
        }
    }
}

