/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.i18n;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class Message {
    String code;
    Object[] parameters;
    ResourceBundle bundle;

    public Message(String key, Logger logger, Object ... params) {
        this(key, logger.getResourceBundle(), params);
    }

    public Message(String key, ResourceBundle catalog, Object ... params) {
        this.code = key;
        this.bundle = catalog;
        this.parameters = params;
    }

    public String toString() {
        String fmt = null;
        try {
            if (null == this.bundle) {
                return this.code;
            }
            fmt = this.bundle.getString(this.code);
        }
        catch (MissingResourceException ex) {
            return this.code;
        }
        return MessageFormat.format(fmt, this.parameters);
    }

    public String getCode() {
        return this.code;
    }

    public Object[] getParameters() {
        return this.parameters;
    }
}

