/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private Class beanClass;

    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        boolean setBus = this.parseAttributes(element, ctx, bean);
        if (!setBus && ctx.getRegistry().containsBeanDefinition("cxf") && this.hasBusProperty()) {
            this.wireBus(bean, "cxf");
        }
        this.parseChildElements(element, ctx, bean);
    }

    protected boolean parseAttributes(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        NamedNodeMap atts = element.getAttributes();
        boolean setBus = false;
        for (int i = 0; i < atts.getLength(); ++i) {
            String prefix;
            Attr node = (Attr)atts.item(i);
            String val = node.getValue();
            String pre = node.getPrefix();
            String name = node.getLocalName();
            if (this.isNamespace(name, prefix = node.getPrefix())) continue;
            if ("createdFromAPI".equals(name)) {
                bean.setAbstract(true);
                continue;
            }
            if ("abstract".equals(name)) {
                bean.setAbstract(true);
                continue;
            }
            if ("depends-on".equals(name)) {
                bean.addDependsOn(val);
                continue;
            }
            if ("id".equals(name) || "name".equals(name) || !this.isAttribute(pre, name)) continue;
            if ("bus".equals(name)) {
                if (val == null || val.trim().length() <= 0 || !ctx.getRegistry().containsBeanDefinition(val)) continue;
                bean.addPropertyReference(name, val);
                setBus = true;
                continue;
            }
            this.mapAttribute(bean, element, name, val);
        }
        return setBus;
    }

    private boolean isNamespace(String name, String prefix) {
        return "xmlns".equals(prefix) || prefix == null && "xmlns".equals(name);
    }

    protected void parseChildElements(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            String name = n.getLocalName();
            this.mapElement(ctx, bean, (Element)n, name);
        }
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }

    protected Class getBeanClass(Element e) {
        return this.beanClass;
    }

    protected void mapAttribute(BeanDefinitionBuilder bean, Element e, String name, String val) {
        this.mapAttribute(bean, name, val);
    }

    protected void mapAttribute(BeanDefinitionBuilder bean, String name, String val) {
        this.mapToProperty(bean, name, val);
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element e, String name) {
    }

    protected String resolveId(Element elem, AbstractBeanDefinition definition, ParserContext ctx) throws BeanDefinitionStoreException {
        String id = this.getIdOrName(elem);
        String createdFromAPI = elem.getAttribute("createdFromAPI");
        if (null == id || "".equals(id)) {
            return super.resolveId(elem, definition, ctx);
        }
        if (createdFromAPI != null && "true".equals(createdFromAPI.toLowerCase())) {
            return id + this.getSuffix();
        }
        return id;
    }

    protected boolean hasBusProperty() {
        return false;
    }

    protected String getSuffix() {
        return "";
    }

    protected void setFirstChildAsProperty(Element element, ParserContext ctx, BeanDefinitionBuilder bean, String propertyName) {
        String id = this.getAndRegisterFirstChild(element, ctx, bean, propertyName);
        bean.addPropertyReference(propertyName, id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getAndRegisterFirstChild(Element element, ParserContext ctx, BeanDefinitionBuilder bean, String propertyName) {
        String id;
        BeanDefinition child;
        Element first = this.getFirstChild(element);
        if (first == null) {
            throw new IllegalStateException(propertyName + " property must have child elements!");
        }
        if (first.getNamespaceURI().equals("http://www.springframework.org/schema/beans")) {
            String name = first.getLocalName();
            if ("ref".equals(name)) {
                String id2 = first.getAttribute("bean");
                if (id2 != null) return id2;
                throw new IllegalStateException("<ref> elements must have a \"bean\" attribute!");
            }
            if (!"bean".equals(name)) throw new UnsupportedOperationException("Elements with the name " + name + " are not currently " + "supported as sub elements of " + element.getLocalName());
            BeanDefinitionHolder bdh = ctx.getDelegate().parseBeanDefinitionElement(first);
            child = bdh.getBeanDefinition();
            id = bdh.getBeanName();
        } else {
            child = ctx.getDelegate().parseCustomElement(first, (BeanDefinition)bean.getBeanDefinition());
            id = child.toString();
        }
        ctx.getRegistry().registerBeanDefinition(id, child);
        return id;
    }

    protected Element getFirstChild(Element element) {
        Element first = null;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            first = (Element)n;
        }
        return first;
    }

    protected void wireBus(BeanDefinitionBuilder bean, String busId) {
        bean.addPropertyReference("bus", busId);
    }

    protected void mapElementToJaxbProperty(Element parent, BeanDefinitionBuilder bean, QName name, String propertyName) {
        this.mapElementToJaxbProperty(parent, bean, name, propertyName, null);
    }

    protected void mapElementToJaxbProperty(Element parent, BeanDefinitionBuilder bean, QName name, String propertyName, Class<?> c) {
        Node data = null;
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !name.getLocalPart().equals(n.getLocalName()) || !name.getNamespaceURI().equals(n.getNamespaceURI())) continue;
            data = n;
            break;
        }
        if (data == null) {
            return;
        }
        JAXBContext context = null;
        Object obj = null;
        try {
            String pkg = this.getJaxbPackage();
            if (null != c) {
                pkg = c.getPackage().getName();
            }
            context = JAXBContext.newInstance((String)pkg, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            Unmarshaller u = context.createUnmarshaller();
            obj = c != null ? u.unmarshal(data, c) : u.unmarshal(data);
            if (obj instanceof JAXBElement) {
                JAXBElement el = (JAXBElement)obj;
                obj = el.getValue();
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not parse configuration.", e);
        }
        if (obj != null) {
            bean.addPropertyValue(propertyName, obj);
        }
    }

    protected String getJaxbPackage() {
        return "";
    }

    protected void mapToProperty(BeanDefinitionBuilder bean, String propertyName, String val) {
        if ("id".equals(propertyName)) {
            return;
        }
        if (StringUtils.hasText((String)val)) {
            if (val.startsWith("#")) {
                bean.addPropertyReference(propertyName, val.substring(1));
            } else {
                bean.addPropertyValue(propertyName, (Object)val);
            }
        }
    }

    protected boolean isAttribute(String pre, String name) {
        return !"xmlns".equals(name) && (pre == null || !pre.equals("xmlns")) && !"abstract".equals(name) && !"lazy-init".equals(name) && !"id".equals(name);
    }

    protected QName parseQName(Element element, String t) {
        int colIdx;
        String ns = null;
        String pre = null;
        String local = null;
        if (t.startsWith("{")) {
            int i = t.indexOf(125);
            if (i == -1) {
                throw new RuntimeException("Namespace bracket '{' must having a closing bracket '}'.");
            }
            ns = t.substring(1, i);
            t = t.substring(i + 1);
        }
        if ((colIdx = t.indexOf(58)) == -1) {
            local = t;
            pre = "";
            ns = DOMUtils.getNamespace(element, "");
        } else {
            pre = t.substring(0, colIdx);
            local = t.substring(colIdx + 1);
            ns = DOMUtils.getNamespace(element, pre);
        }
        return new QName(ns, local, pre);
    }

    protected String getIdOrName(Element elem) {
        StringTokenizer st;
        String names;
        String id = elem.getAttribute("id");
        if ((null == id || "".equals(id)) && null != (names = elem.getAttribute("name")) && (st = new StringTokenizer(names, ",; ")).countTokens() > 0) {
            id = st.nextToken();
        }
        return id;
    }
}

