/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxfse;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceRef;
import org.apache.cxf.Bus;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.ServiceImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.jbi.JBIDestination;
import org.apache.cxf.transport.jbi.JBIDispatcherUtil;
import org.apache.cxf.transport.jbi.JBITransportFactory;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.cxfse.CxfSeComponent;
import org.apache.servicemix.cxfse.interceptors.AttachmentInInterceptor;
import org.apache.servicemix.cxfse.interceptors.AttachmentOutInterceptor;
import org.apache.servicemix.cxfse.support.ReflectionUtils;
import org.apache.servicemix.id.IdGenerator;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfSeEndpoint
extends ProviderEndpoint
implements InterceptorProvider {
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    private Object pojo;
    private EndpointImpl endpoint;
    private String address;
    private List<Interceptor> in = new CopyOnWriteArrayList<Interceptor>();
    private List<Interceptor> out = new CopyOnWriteArrayList<Interceptor>();
    private List<Interceptor> outFault = new CopyOnWriteArrayList<Interceptor>();
    private List<Interceptor> inFault = new CopyOnWriteArrayList<Interceptor>();
    private Map properties;
    private boolean mtomEnabled;
    private boolean schemaValidationEnabled;
    private boolean useJBIWrapper = true;

    public Object getPojo() {
        return this.pojo;
    }

    public void setPojo(Object pojo) {
        this.pojo = pojo;
    }

    public List<Interceptor> getOutFaultInterceptors() {
        return this.outFault;
    }

    public List<Interceptor> getInFaultInterceptors() {
        return this.inFault;
    }

    public List<Interceptor> getInInterceptors() {
        return this.in;
    }

    public List<Interceptor> getOutInterceptors() {
        return this.out;
    }

    public void setInInterceptors(List<Interceptor> interceptors) {
        this.in = interceptors;
    }

    public void setInFaultInterceptors(List<Interceptor> interceptors) {
        this.inFault = interceptors;
    }

    public void setOutInterceptors(List<Interceptor> interceptors) {
        this.out = interceptors;
    }

    public void setOutFaultInterceptors(List<Interceptor> interceptors) {
        this.outFault = interceptors;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void validate() throws DeploymentException {
        if (this.getPojo() == null) {
            throw new DeploymentException("pojo must be set");
        }
        JaxWsServiceFactoryBean serviceFactory = new JaxWsServiceFactoryBean();
        serviceFactory.setPopulateFromClass(true);
        this.endpoint = new EndpointImpl(this.getBus(), this.getPojo(), new JaxWsServerFactoryBean(serviceFactory));
        if (this.isUseJBIWrapper()) {
            this.endpoint.setBindingUri("http://cxf.apache.org/bindings/jbi");
        }
        this.endpoint.setInInterceptors(this.getInInterceptors());
        this.endpoint.setInFaultInterceptors(this.getInFaultInterceptors());
        this.endpoint.setOutInterceptors(this.getOutInterceptors());
        this.endpoint.setOutFaultInterceptors(this.getOutFaultInterceptors());
        if (this.isMtomEnabled()) {
            this.endpoint.getInInterceptors().add(new AttachmentInInterceptor());
            this.endpoint.getOutInterceptors().add(new AttachmentOutInterceptor());
        }
        if (this.isSchemaValidationEnabled()) {
            if (this.endpoint.getProperties() == null) {
                this.endpoint.setProperties(new HashMap());
            }
            this.endpoint.getProperties().put("schema-validation-enabled", true);
        }
        JaxWsImplementorInfo implInfo = new JaxWsImplementorInfo(this.getPojo().getClass());
        this.setService(implInfo.getServiceName());
        this.setInterfaceName(implInfo.getInterfaceName());
        this.setEndpoint(implInfo.getEndpointName().getLocalPart());
        super.validate();
    }

    public void process(MessageExchange exchange) throws Exception {
        QName interfaceName;
        QName opeName = exchange.getOperation();
        EndpointInfo ei = this.endpoint.getServer().getEndpoint().getEndpointInfo();
        if (opeName == null) {
            if (ei.getBinding().getOperations().size() == 1) {
                opeName = ((BindingOperationInfo)ei.getBinding().getOperations().iterator().next()).getName();
                exchange.setOperation(opeName);
            } else {
                throw new Fault((Throwable)new Exception("Operation not bound on this MessageExchange"));
            }
        }
        JBITransportFactory jbiTransportFactory = (JBITransportFactory)((ConduitInitiatorManager)this.getBus().getExtension(ConduitInitiatorManager.class)).getConduitInitiator("http://cxf.apache.org/transports/jbi");
        QName serviceName = exchange.getService();
        if (serviceName == null) {
            serviceName = this.getService();
            exchange.setService(serviceName);
        }
        if ((interfaceName = exchange.getInterfaceName()) == null) {
            interfaceName = this.getInterfaceName();
            exchange.setInterfaceName(interfaceName);
        }
        JBIDestination jbiDestination = jbiTransportFactory.getDestination(serviceName.toString() + interfaceName.toString());
        DeliveryChannel dc = this.getContext().getDeliveryChannel();
        jbiTransportFactory.setDeliveryChannel(dc);
        jbiDestination.setDeliveryChannel(dc);
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            jbiDestination.getJBIDispatcherUtil().dispatch(exchange);
        }
    }

    public void start() throws Exception {
        super.start();
        this.address = "jbi://" + ID_GENERATOR.generateSanitizedId();
        try {
            this.endpoint.publish(this.address);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setService(this.endpoint.getServer().getEndpoint().getService().getName());
        this.setEndpoint(this.endpoint.getServer().getEndpoint().getEndpointInfo().getName().getLocalPart());
        try {
            this.definition = new ServiceWSDLBuilder(this.getBus(), new ServiceInfo[]{(ServiceInfo)this.endpoint.getServer().getEndpoint().getService().getServiceInfos().iterator().next()}).build();
            this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.definition);
        }
        catch (WSDLException e) {
            throw new DeploymentException((Throwable)e);
        }
        ReflectionUtils.doWithFields(this.getPojo().getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                if (field.getAnnotation(WebServiceRef.class) != null) {
                    ServiceImpl s = new ServiceImpl(CxfSeEndpoint.this.getBus(), null, null, field.getType());
                    s.addPort(new QName("port"), "http://cxf.apache.org/transports/jbi", "jbi://" + ID_GENERATOR.generateSanitizedId());
                    Object o = s.getPort(new QName("port"), field.getType());
                    field.setAccessible(true);
                    field.set(CxfSeEndpoint.this.getPojo(), o);
                }
            }
        });
        ReflectionUtils.callLifecycleMethod(this.getPojo(), PostConstruct.class);
        this.injectPojo();
    }

    public void stop() throws Exception {
        this.endpoint.stop();
        ReflectionUtils.callLifecycleMethod(this.getPojo(), PreDestroy.class);
        JBIDispatcherUtil.clean();
        JBITransportFactory jbiTransportFactory = (JBITransportFactory)((ConduitInitiatorManager)this.getBus().getExtension(ConduitInitiatorManager.class)).getConduitInitiator("http://cxf.apache.org/transports/jbi");
        jbiTransportFactory.removeDestination(this.getService().toString() + this.getInterfaceName().toString());
        super.stop();
    }

    protected Bus getBus() {
        return ((CxfSeComponent)this.getServiceUnit().getComponent()).getBus();
    }

    @PostConstruct
    protected void injectPojo() {
        try {
            ComponentContext context = this.getContext();
            Method mth = this.pojo.getClass().getMethod("setContext", ComponentContext.class);
            if (mth != null) {
                mth.invoke(this.pojo, context);
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)("Unable to inject ComponentContext: " + e.getMessage()));
        }
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public boolean isSchemaValidationEnabled() {
        return this.schemaValidationEnabled;
    }

    public void setSchemaValidationEnabled(boolean schemaValidationEnabled) {
        this.schemaValidationEnabled = schemaValidationEnabled;
    }

    public void setUseJBIWrapper(boolean useJBIWrapper) {
        this.useJBIWrapper = useJBIWrapper;
    }

    public boolean isUseJBIWrapper() {
        return this.useJBIWrapper;
    }
}

