/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import org.apache.geronimo.mail.util.SessionUtil;

public class MimeMultipart
extends Multipart {
    private static final String MIME_IGNORE_MISSING_BOUNDARY = "mail.mime.multipart.ignoremissingendboundary";
    protected DataSource ds;
    protected boolean parsed = true;
    private transient ContentType type;
    private boolean complete = true;
    private String preamble = null;
    private static byte[] dash = new byte[]{45, 45};
    private static byte[] crlf = new byte[]{13, 10};
    private static int part;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String subtype) {
        this.type = new ContentType("multipart", subtype, null);
        this.type.setParameter("boundary", MimeMultipart.getBoundary());
        this.contentType = this.type.toString();
    }

    public MimeMultipart(DataSource dataSource) throws MessagingException {
        this.ds = dataSource;
        if (dataSource instanceof MultipartDataSource) {
            super.setMultipartDataSource((MultipartDataSource)dataSource);
            this.parsed = true;
        } else {
            this.type = new ContentType(this.ds.getContentType());
            this.contentType = this.type.toString();
            this.parsed = false;
        }
    }

    public void setSubType(String subtype) throws MessagingException {
        this.type.setSubType(subtype);
        this.contentType = this.type.toString();
    }

    public int getCount() throws MessagingException {
        this.parse();
        return super.getCount();
    }

    public synchronized BodyPart getBodyPart(int part) throws MessagingException {
        this.parse();
        return super.getBodyPart(part);
    }

    public BodyPart getBodyPart(String cid) throws MessagingException {
        this.parse();
        for (int i = 0; i < this.parts.size(); ++i) {
            MimeBodyPart bodyPart = (MimeBodyPart)this.parts.get(i);
            if (!cid.equals(bodyPart.getContentID())) continue;
            return bodyPart;
        }
        return null;
    }

    protected void updateHeaders() throws MessagingException {
        this.parse();
        for (int i = 0; i < this.parts.size(); ++i) {
            MimeBodyPart bodyPart = (MimeBodyPart)this.parts.get(i);
            bodyPart.updateHeaders();
        }
    }

    public void writeTo(OutputStream out) throws IOException, MessagingException {
        this.parse();
        String boundary = this.type.getParameter("boundary");
        byte[] bytes = boundary.getBytes();
        if (this.preamble != null) {
            byte[] preambleBytes = this.preamble.getBytes();
            out.write(preambleBytes);
            out.write(crlf);
        }
        for (int i = 0; i < this.parts.size(); ++i) {
            BodyPart bodyPart = (BodyPart)this.parts.get(i);
            out.write(dash);
            out.write(bytes);
            out.write(crlf);
            bodyPart.writeTo(out);
            out.write(crlf);
        }
        out.write(dash);
        out.write(bytes);
        out.write(dash);
        out.write(crlf);
        out.flush();
    }

    protected void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        try {
            ContentType cType = new ContentType(this.contentType);
            byte[] boundary = ("--" + cType.getParameter("boundary")).getBytes();
            BufferedInputStream is = new BufferedInputStream(this.ds.getInputStream());
            PushbackInputStream pushbackInStream = new PushbackInputStream(is, boundary.length + 2);
            this.readTillFirstBoundary(pushbackInStream, boundary);
            while (pushbackInStream.available() > 0) {
                MimeBodyPartInputStream partStream = new MimeBodyPartInputStream(pushbackInStream, boundary);
                this.addBodyPart(new MimeBodyPart(partStream));
                if (partStream.boundaryFound) continue;
                if (!SessionUtil.getBooleanProperty(MIME_IGNORE_MISSING_BOUNDARY, true)) {
                    throw new MessagingException("Missing Multi-part end boundary");
                }
                this.complete = false;
            }
        }
        catch (Exception e) {
            throw new MessagingException(e.toString(), e);
        }
        this.parsed = true;
    }

    private boolean readTillFirstBoundary(PushbackInputStream pushbackInStream, byte[] boundary) throws MessagingException {
        ByteArrayOutputStream preambleStream = new ByteArrayOutputStream();
        try {
            while (pushbackInStream.available() > 0) {
                int value = pushbackInStream.read();
                if ((byte)value == boundary[0]) {
                    int boundaryIndex;
                    for (boundaryIndex = 0; pushbackInStream.available() > 0 && boundaryIndex < boundary.length && (byte)value == boundary[boundaryIndex]; ++boundaryIndex) {
                        value = pushbackInStream.read();
                        if (value != -1) continue;
                        throw new MessagingException("Unexpected End of Stream while searching for first Mime Boundary");
                    }
                    if (boundaryIndex == boundary.length) {
                        pushbackInStream.read();
                        byte[] preambleBytes = preambleStream.toByteArray();
                        if (preambleBytes.length > 0) {
                            this.preamble = new String(preambleBytes);
                        }
                        return true;
                    }
                    preambleStream.write(boundary, 0, boundaryIndex);
                    preambleStream.write((byte)value);
                    continue;
                }
                preambleStream.write((byte)value);
            }
        }
        catch (IOException ioe) {
            throw new MessagingException(ioe.toString(), ioe);
        }
        return false;
    }

    protected InternetHeaders createInternetHeaders(InputStream in) throws MessagingException {
        return new InternetHeaders(in);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders headers, byte[] data) throws MessagingException {
        return new MimeBodyPart(headers, data);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream in) throws MessagingException {
        return new MimeBodyPart(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String getBoundary() {
        Class<MimeMultipart> clazz = MimeMultipart.class;
        synchronized (MimeMultipart.class) {
            int i = part++;
            // ** MonitorExit[var1] (shouldn't be in output)
            StringBuffer buf = new StringBuffer(64);
            buf.append("----=_Part_").append(i).append('_').append(new Object().hashCode()).append('.').append(System.currentTimeMillis());
            return buf.toString();
        }
    }

    public boolean isComplete() throws MessagingException {
        this.parse();
        return this.complete;
    }

    public String getPreamble() throws MessagingException {
        this.parse();
        return this.preamble;
    }

    public void setPreamble(String preamble) throws MessagingException {
        this.preamble = preamble;
    }

    private class MimeBodyPartInputStream
    extends InputStream {
        PushbackInputStream inStream;
        public boolean boundaryFound = false;
        byte[] boundary;

        public MimeBodyPartInputStream(PushbackInputStream inStream, byte[] boundary) {
            this.inStream = inStream;
            this.boundary = boundary;
        }

        public int read() throws IOException {
            int boundaryIndex;
            if (this.boundaryFound) {
                return -1;
            }
            int value = this.inStream.read();
            if (value == 13) {
                value = this.inStream.read();
                if (value != 10) {
                    this.inStream.unread(value);
                    return 13;
                }
                value = this.inStream.read();
                if ((byte)value != this.boundary[0]) {
                    this.inStream.unread(value);
                    this.inStream.unread(10);
                    return 13;
                }
            } else if ((byte)value != this.boundary[0]) {
                return value;
            }
            for (boundaryIndex = 0; boundaryIndex < this.boundary.length && (byte)value == this.boundary[boundaryIndex]; ++boundaryIndex) {
                value = this.inStream.read();
            }
            if (boundaryIndex == this.boundary.length) {
                this.boundaryFound = true;
                if (this.inStream.read() == 45 && value == 45) {
                    this.inStream.read();
                    this.inStream.read();
                }
                return -1;
            }
            if (value != -1) {
                this.inStream.unread(value);
            }
            this.inStream.unread(this.boundary, 1, boundaryIndex - 1);
            return this.boundary[0];
        }
    }
}

