/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpHeaderHelper {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_ID = "Content-ID";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String COOKIE = "Cookie";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String CHUNKED = "chunked";
    public static final String CONNECTION = "Connection";
    public static final String CLOSE = "close";
    public static final String AUTHORIZATION = "Authorization";
    private static final Charset UTF8 = Charset.forName("utf-8");
    private static Map<String, String> internalHeaders = new HashMap<String, String>();
    private static Map<String, String> encodings = new ConcurrentHashMap<String, String>();

    private HttpHeaderHelper() {
    }

    public static List getHeader(Map<String, List<String>> headerMap, String key) {
        return headerMap.get(HttpHeaderHelper.getHeaderKey(key));
    }

    public static String getHeaderKey(String key) {
        if (internalHeaders.containsKey(key)) {
            return internalHeaders.get(key);
        }
        return key;
    }

    public static String mapCharset(String enc) {
        if (enc == null) {
            return UTF8.name();
        }
        int idx = enc.indexOf(";");
        if (idx != -1) {
            enc = enc.substring(0, idx);
        }
        enc = enc.replace("\"", "").trim();
        if ("".equals(enc = enc.replace("'", ""))) {
            return UTF8.name();
        }
        String newenc = encodings.get(enc);
        if (newenc == null) {
            try {
                newenc = Charset.forName(enc).name();
            }
            catch (IllegalCharsetNameException icne) {
                return null;
            }
            catch (UnsupportedCharsetException uce) {
                return null;
            }
            encodings.put(enc, newenc);
        }
        return newenc;
    }

    static {
        internalHeaders.put(CONTENT_TYPE, "content-type");
        internalHeaders.put(CONTENT_ID, "content-id");
        internalHeaders.put(CONTENT_TRANSFER_ENCODING, "content-transfer-encoding");
        internalHeaders.put(TRANSFER_ENCODING, "transfer-encoding");
        internalHeaders.put(CONNECTION, "connection");
        internalHeaders.put("authorization", AUTHORIZATION);
        internalHeaders.put("soapaction", "SOAPAction");
        internalHeaders.put("accept", "Accept");
    }
}

