/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jbi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.w3c.dom.Document;

public class JBIDestinationOutputStream
extends CachedOutputStream {
    private static final String SEND_SYNC = "javax.jbi.messaging.sendSync";
    private static final Logger LOG = LogUtils.getL7dLogger(JBIDestinationOutputStream.class);
    private Message inMessage;
    private Message outMessage;
    private DeliveryChannel channel;

    public JBIDestinationOutputStream(Message m, Message outM, DeliveryChannel dc) {
        this.inMessage = m;
        this.outMessage = outM;
        this.channel = dc;
    }

    protected void doFlush() throws IOException {
    }

    protected void doClose() throws IOException {
        this.commitOutputMessage();
    }

    protected void onWrite() throws IOException {
    }

    private void commitOutputMessage() throws IOException {
        try {
            if (this.inMessage.getExchange().isOneWay()) {
                return;
            }
            InputStream bais = this.getInputStream();
            LOG.finest(new org.apache.cxf.common.i18n.Message("BUILDING.DOCUMENT", LOG, new Object[0]).toString());
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = builder.parse(bais);
            MessageExchange xchng = (MessageExchange)this.inMessage.get(MessageExchange.class);
            LOG.fine(new org.apache.cxf.common.i18n.Message("CREATE.NORMALIZED.MESSAGE", LOG, new Object[0]).toString());
            if (this.inMessage.getExchange().getOutFaultMessage() != null) {
                org.apache.cxf.interceptor.Fault f = (org.apache.cxf.interceptor.Fault)this.inMessage.getContent(Exception.class);
                if (!(f.getCause() instanceof Error)) {
                    Fault fault = xchng.createFault();
                    fault.setContent((Source)new DOMSource(doc));
                    xchng.setFault(fault);
                    if (!f.hasDetails()) {
                        xchng.setProperty("faultstring", (Object)f.getMessage());
                    }
                } else {
                    xchng.setError((Exception)f);
                }
            } else {
                NormalizedMessage msg = xchng.createMessage();
                if (this.outMessage != null && this.outMessage.getAttachments() != null) {
                    for (Attachment att : this.outMessage.getAttachments()) {
                        msg.addAttachment(att.getId(), att.getDataHandler());
                    }
                }
                for (Map.Entry ent : this.inMessage.entrySet()) {
                    if (!(ent.getValue() instanceof Serializable) || ent.getValue() instanceof Map || ent.getValue() instanceof Collection) continue;
                    msg.setProperty((String)ent.getKey(), ent.getValue());
                }
                msg.setContent((Source)new DOMSource(doc));
                xchng.setMessage(msg, "out");
            }
            LOG.fine(new org.apache.cxf.common.i18n.Message("POST.DISPATCH", LOG, new Object[0]).toString());
            if (xchng.getStatus() == ExchangeStatus.ACTIVE && Boolean.TRUE.equals(xchng.getProperty(SEND_SYNC))) {
                this.channel.sendSync(xchng);
            } else {
                this.channel.send(xchng);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, new org.apache.cxf.common.i18n.Message("ERROR.SEND.MESSAGE", LOG, new Object[0]).toString(), ex);
        }
    }
}

