/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamDataReader
implements DataReader<XMLStreamReader> {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLStreamDataReader.class);

    public Object read(MessagePartInfo part, XMLStreamReader input) {
        return this.read(null, input, part.getTypeClass());
    }

    public Object read(final QName name, XMLStreamReader input, Class type) {
        if (type != null) {
            if (SAXSource.class.isAssignableFrom(type)) {
                try {
                    return new SAXSource(new InputSource(this.getInputStream(input)));
                }
                catch (IOException e) {
                    throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
                }
                catch (XMLStreamException e) {
                    throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
                }
            }
            if (StreamSource.class.isAssignableFrom(type)) {
                try {
                    return new StreamSource(this.getInputStream(input));
                }
                catch (IOException e) {
                    throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
                }
                catch (XMLStreamException e) {
                    throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
                }
            }
            if (DataSource.class.isAssignableFrom(type)) {
                try {
                    final InputStream ins = this.getInputStream(input);
                    return new DataSource(){

                        public String getContentType() {
                            return "text/xml";
                        }

                        public InputStream getInputStream() throws IOException {
                            return ins;
                        }

                        public String getName() {
                            return name.toString();
                        }

                        public OutputStream getOutputStream() throws IOException {
                            return null;
                        }
                    };
                }
                catch (IOException e) {
                    throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
                }
                catch (XMLStreamException e) {
                    throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
                }
            }
        }
        return this.read(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream(XMLStreamReader input) throws XMLStreamException, IOException {
        CachedOutputStream out = new CachedOutputStream();
        try {
            XMLStreamWriter xsw = StaxUtils.createXMLStreamWriter((OutputStream)out);
            StaxUtils.copy((XMLStreamReader)input, (XMLStreamWriter)xsw);
            xsw.close();
            InputStream inputStream = out.getInputStream();
            return inputStream;
        }
        finally {
            out.close();
        }
    }

    public Object read(XMLStreamReader reader) {
        try {
            XMLStreamReader reader2 = reader;
            if (reader2 instanceof DepthXMLStreamReader) {
                reader2 = ((DepthXMLStreamReader)reader2).getReader();
            }
            if (reader2 instanceof W3CDOMStreamReader) {
                W3CDOMStreamReader domreader = (W3CDOMStreamReader)reader2;
                DOMSource o = new DOMSource(domreader.getCurrentElement());
                domreader.consumeFrame();
                return o;
            }
            Document document = StaxUtils.read((XMLStreamReader)reader);
            return new DOMSource(document);
        }
        catch (XMLStreamException e) {
            throw new Fault(new Message("COULD_NOT_READ_XML_STREAM", LOG, new Object[0]), (Throwable)e);
        }
    }

    public void setSchema(Schema s) {
    }

    public void setAttachments(Collection<Attachment> attachments) {
    }

    public void setProperty(String prop, Object value) {
    }
}

