/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxws.handler.HandlerChainBuilder;
import org.apache.cxf.jaxws.javaee.HandlerChainType;
import org.apache.cxf.jaxws.javaee.HandlerChainsType;
import org.apache.cxf.jaxws.javaee.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHandlerChainBuilder
extends HandlerChainBuilder {
    private static final Logger LOG = LogUtils.getL7dLogger(AnnotationHandlerChainBuilder.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();

    public AnnotationHandlerChainBuilder() {
    }

    public AnnotationHandlerChainBuilder(Bus bus) {
        super(bus);
    }

    public List<Handler> buildHandlerChainFromClass(Class<?> clz, List<Handler> existingHandlers, QName endpointName) {
        LOG.fine("building handler chain");
        HandlerChainAnnotation hcAnn = this.findHandlerChainAnnotation(clz, true);
        ArrayList<Object> chain = null;
        if (hcAnn == null) {
            LOG.fine("no HandlerChain annotation on " + clz);
            chain = new ArrayList<Handler>();
        } else {
            hcAnn.validate();
            try {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
                Unmarshaller u = jc.createUnmarshaller();
                URL handlerFileURL = this.resolveHandlerChainFile(clz, hcAnn.getFileName());
                if (handlerFileURL == null) {
                    throw new WebServiceException(new Message("HANDLER_CFG_FILE_NOT_FOUND_EXC", BUNDLE, new Object[]{hcAnn.getFileName()}).toString());
                }
                JAXBElement o = (JAXBElement)u.unmarshal(handlerFileURL);
                HandlerChainsType handlerChainsType = (HandlerChainsType)o.getValue();
                if (null == handlerChainsType || handlerChainsType.getHandlerChain().size() == 0) {
                    throw new WebServiceException(BUNDLE.getString("CHAIN_NOT_SPECIFIED_EXC"));
                }
                chain = new ArrayList();
                for (HandlerChainType hc : handlerChainsType.getHandlerChain()) {
                    String portNamePattern;
                    String localPart;
                    if (hc.getPortNamePattern() != null && endpointName != null && !(localPart = (portNamePattern = hc.getPortNamePattern()).substring(portNamePattern.indexOf(58) + 1, portNamePattern.length())).equals(endpointName.getLocalPart())) continue;
                    chain.addAll(this.buildHandlerChain(hc, clz.getClassLoader()));
                }
            }
            catch (Exception e) {
                throw new WebServiceException(BUNDLE.getString("CHAIN_NOT_SPECIFIED_EXC"), (Throwable)e);
            }
        }
        assert (chain != null);
        if (existingHandlers != null) {
            chain.addAll(existingHandlers);
        }
        return this.sortHandlers(chain);
    }

    protected URL resolveHandlerChainAnnotationFile(Class clazz, String name) {
        return clazz.getResource(name);
    }

    public List<Handler> buildHandlerChainFromClass(Class<?> clz, QName endpointName) {
        return this.buildHandlerChainFromClass(clz, null, endpointName);
    }

    public List<Handler> buildHandlerChainFromClass(Class<?> clz) {
        return this.buildHandlerChainFromClass(clz, null, null);
    }

    private HandlerChainAnnotation findHandlerChainAnnotation(Class<?> clz, boolean searchSEI) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Checking for HandlerChain annotation on " + clz.getName());
        }
        HandlerChainAnnotation hcAnn = null;
        HandlerChain ann = clz.getAnnotation(HandlerChain.class);
        if (ann == null) {
            WebService ws;
            if (searchSEI && (ws = clz.getAnnotation(WebService.class)) != null && !StringUtils.isEmpty((String)ws.endpointInterface())) {
                String seiClassName = ws.endpointInterface().trim();
                Class<?> seiClass = null;
                try {
                    seiClass = clz.getClassLoader().loadClass(seiClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new WebServiceException(BUNDLE.getString("SEI_LOAD_FAILURE_EXC"), (Throwable)e);
                }
                hcAnn = this.findHandlerChainAnnotation(seiClass, false);
            }
            if (hcAnn == null) {
                for (Class<?> iface : clz.getInterfaces()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Checking for HandlerChain annotation on " + iface.getName());
                    }
                    if ((ann = iface.getAnnotation(HandlerChain.class)) == null) continue;
                    hcAnn = new HandlerChainAnnotation(ann, iface);
                    break;
                }
            }
        } else {
            hcAnn = new HandlerChainAnnotation(ann, clz);
        }
        return hcAnn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HandlerChainAnnotation {
        private final Class<?> declaringClass;
        private final HandlerChain ann;

        HandlerChainAnnotation(HandlerChain hc, Class<?> clz) {
            this.ann = hc;
            this.declaringClass = clz;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public String getFileName() {
            return this.ann.file();
        }

        public void validate() {
            if (null == this.ann.file() || "".equals(this.ann.file())) {
                throw new WebServiceException(BUNDLE.getString("ANNOTATION_WITHOUT_URL_EXC"));
            }
        }

        public String toString() {
            return "[" + this.declaringClass + "," + this.ann + "]";
        }
    }
}

