/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.commands;

import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.commands.ForkedCommandException;
import org.apache.cxf.common.commands.ForkedCommandStreamHandler;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;

public class ForkedCommand
extends Thread {
    public static final String EXE_SUFFIX;
    public static final int DEFAULT_TIMEOUT = 0;
    private static final Logger LOG;
    private String[] arguments;
    private String[] environment;
    private PrintStream outputStream;
    private PrintStream errorStream;
    private Process proc;
    private boolean completed;
    private boolean killed;
    private boolean joinErrOut = true;

    public ForkedCommand() {
    }

    public ForkedCommand(String[] args) {
        this.arguments = args;
    }

    protected void setArgs(String[] args) {
        this.arguments = args;
    }

    public void setEnvironment(String[] env) {
        this.environment = env;
    }

    public String toString() {
        if (null == this.arguments) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            boolean quotesNeeded = false;
            if (this.arguments[i] != null) {
                StringTokenizer st = new StringTokenizer(this.arguments[i]);
                boolean bl = quotesNeeded = st.countTokens() > 1;
            }
            if (quotesNeeded) {
                buf.append("\"");
            }
            buf.append(this.arguments[i]);
            if (!quotesNeeded) continue;
            buf.append("\"");
        }
        return buf.length() > 0 ? buf.toString() : "";
    }

    public void joinErrOut(boolean flag) {
        this.joinErrOut = flag;
    }

    public int execute() {
        return this.execute(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int execute(int timeout) {
        block35: {
            ForkedCommandStreamHandler cmdErr;
            ForkedCommandStreamHandler cmdOut;
            block36: {
                block34: {
                    if (null == this.arguments || this.arguments.length == 0) {
                        throw new ForkedCommandException(new Message("NO_ARGUMENTS_EXC", LOG, new Object[0]));
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Executing command: " + this);
                    }
                    try {
                        Runtime rt = Runtime.getRuntime();
                        if (this.environment == null) {
                            this.proc = rt.exec(this.arguments);
                        } else {
                            StringBuffer msg = null;
                            if (LOG.isLoggable(Level.FINE)) {
                                msg = new StringBuffer();
                                msg.append("Process environment: ");
                                for (int i = 0; i < this.environment.length; ++i) {
                                    msg.append(this.environment[i]);
                                    msg.append(" ");
                                }
                                LOG.fine(msg.toString());
                            }
                            this.proc = rt.exec(this.arguments, this.environment);
                        }
                    }
                    catch (IOException ex) {
                        throw new ForkedCommandException(new Message("EXECUTE_EXC", LOG, this), (Throwable)ex);
                    }
                    cmdOut = new ForkedCommandStreamHandler(this.proc.getInputStream(), this.outputStream == null ? System.out : this.outputStream);
                    cmdErr = new ForkedCommandStreamHandler(this.proc.getErrorStream(), this.errorStream == null ? System.err : this.errorStream);
                    cmdErr.start();
                    cmdOut.start();
                    this.start();
                    if (timeout > 0) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Waiting " + timeout + " seconds for process to complete");
                        }
                        this.join(timeout * 1000);
                        break block34;
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Waiting for process to complete");
                    }
                    this.join();
                }
                Object var6_8 = null;
                if (this.completed) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Process completed in time");
                    }
                } else {
                    this.proc.destroy();
                    this.killed = true;
                    LOG.fine("Process timed out and was killed");
                }
                if (!this.joinErrOut) break block35;
                if (!LOG.isLoggable(Level.FINE)) break block36;
                LOG.info("Waiting a further 10 seconds for process  stdout/stderr streams to be flushed");
            }
            try {
                cmdErr.join(10000L);
                cmdOut.join(10000L);
            }
            catch (InterruptedException ex2) {}
            break block35;
            {
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    Object var6_9 = null;
                    if (this.completed) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Process completed in time");
                        }
                    } else {
                        this.proc.destroy();
                        this.killed = true;
                        LOG.fine("Process timed out and was killed");
                    }
                    if (this.joinErrOut) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.info("Waiting a further 10 seconds for process  stdout/stderr streams to be flushed");
                        }
                        try {
                            cmdErr.join(10000L);
                            cmdOut.join(10000L);
                        }
                        catch (InterruptedException ex2) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (this.completed) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Process completed in time");
                    }
                } else {
                    this.proc.destroy();
                    this.killed = true;
                    LOG.fine("Process timed out and was killed");
                }
                if (this.joinErrOut) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.info("Waiting a further 10 seconds for process  stdout/stderr streams to be flushed");
                    }
                    try {
                        cmdErr.join(10000L);
                        cmdOut.join(10000L);
                    }
                    catch (InterruptedException ex2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (this.killed) {
            throw new ForkedCommandException(new Message("TIMEOUT_EXC", LOG, timeout));
        }
        int exitVal = this.proc.exitValue();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Process exited with value: " + exitVal);
        }
        return exitVal;
    }

    public void run() {
        try {
            this.proc.waitFor();
            this.completed = true;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void setOutputStream(PrintStream os) {
        this.outputStream = os;
    }

    public void setErrorStream(PrintStream es) {
        this.errorStream = es;
    }

    static {
        LOG = LogUtils.getL7dLogger(ForkedCommand.class);
        EXE_SUFFIX = System.getProperty("os.name").startsWith("Windows") ? ".exe" : "";
    }
}

