/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataBinding
implements DataBinding {
    private static final Map<String, String> BUILTIN_SCHEMA_LOCS = new HashMap<String, String>();
    protected int mtomThreshold;
    private Collection<DOMSource> schemas;
    private Map<String, String> namespaceMap;

    public AbstractDataBinding() {
        BUILTIN_SCHEMA_LOCS.put("http://www.w3.org/2005/08/addressing", "http://www.w3.org/2006/03/addressing/ws-addr.xsd");
    }

    public Collection<DOMSource> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Collection<DOMSource> schemas) {
        this.schemas = schemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlSchema addSchemaDocument(ServiceInfo serviceInfo, SchemaCollection col, Document d, String systemId) {
        XmlSchema xmlSchema;
        String ns = d.getDocumentElement().getAttribute("targetNamespace");
        if (StringUtils.isEmpty((String)ns)) {
            d = this.copy(d);
            ns = serviceInfo.getInterface().getName().getNamespaceURI();
            d.getDocumentElement().setAttribute("targetNamespace", ns);
        }
        for (Node n = d.getDocumentElement().getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            if (!(n instanceof Element) || !(e = (Element)n).getLocalName().equals("import")) continue;
            e.removeAttribute("schemaLocation");
            this.updateSchemaLocation(e);
        }
        SchemaInfo schema = new SchemaInfo(ns);
        schema.setSystemId(systemId);
        Document document = d;
        synchronized (document) {
            xmlSchema = col.read(d, systemId, null);
            schema.setSchema(xmlSchema);
        }
        serviceInfo.addSchema(schema);
        return xmlSchema;
    }

    private Document copy(Document doc) {
        try {
            return StaxUtils.copy((Document)doc);
        }
        catch (XMLStreamException e) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return doc;
    }

    protected void updateSchemaLocation(Element e) {
        String ns = e.getAttribute("namespace");
        String newLoc = BUILTIN_SCHEMA_LOCS.get(ns);
        if (newLoc != null) {
            e.setAttribute("schemaLocation", newLoc);
        }
    }

    public Map<String, String> getNamespaceMap() {
        return this.namespaceMap;
    }

    public void setNamespaceMap(Map<String, String> namespaceMap) {
        if (namespaceMap != null) {
            HashSet prefixesSoFar = new HashSet();
            for (Map.Entry<String, String> mapping : namespaceMap.entrySet()) {
                if (!prefixesSoFar.contains(mapping.getValue())) continue;
                throw new IllegalArgumentException("Duplicate prefix " + mapping.getValue());
            }
        }
        this.namespaceMap = namespaceMap;
    }

    @Override
    public Map<String, String> getDeclaredNamespaceMappings() {
        return this.namespaceMap;
    }

    protected static void checkNamespaceMap(Map<String, String> namespaceMap) {
        if (namespaceMap != null) {
            HashSet prefixesSoFar = new HashSet();
            for (Map.Entry<String, String> mapping : namespaceMap.entrySet()) {
                if (!prefixesSoFar.contains(mapping.getValue())) continue;
                throw new IllegalArgumentException("Duplicate prefix " + mapping.getValue());
            }
        }
    }

    @Override
    public int getMtomThreshold() {
        return this.mtomThreshold;
    }

    @Override
    public void setMtomThreshold(int threshold) {
        this.mtomThreshold = threshold;
    }
}

