/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.drools;

import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import org.apache.servicemix.drools.DroolsEndpoint;
import org.apache.servicemix.drools.model.JbiHelper;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.DefaultAgendaEventListener;

public class DroolsExecutionContext
extends DefaultAgendaEventListener {
    private final StatefulSession memory;
    private final JbiHelper helper;
    private int rulesFired;
    private MessageExchange exchange;

    public DroolsExecutionContext(DroolsEndpoint endpoint, MessageExchange exchange) {
        this.memory = endpoint.getRuleBase().newStatefulSession();
        this.memory.addEventListener((AgendaEventListener)this);
        this.exchange = exchange;
        this.helper = new JbiHelper(endpoint, exchange, (WorkingMemory)this.memory);
        this.populateWorkingMemory(endpoint);
    }

    private void populateWorkingMemory(DroolsEndpoint endpoint) {
        this.memory.setGlobal("jbi", (Object)this.helper);
        if (endpoint.getAssertedObjects() != null) {
            for (Object object : endpoint.getAssertedObjects()) {
                this.memory.insert(object);
            }
        }
        if (endpoint.getGlobals() != null) {
            for (Map.Entry entry : endpoint.getGlobals().entrySet()) {
                this.memory.setGlobal((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public void start() {
        this.memory.fireAllRules();
    }

    public void update() {
        this.helper.update();
    }

    public void stop() {
        this.memory.removeEventListener((AgendaEventListener)this);
        this.memory.dispose();
    }

    public int getRulesFired() {
        return this.rulesFired;
    }

    public boolean isExchangeHandled() {
        return this.helper.isExchangeHandled();
    }

    public MessageExchange getExchange() {
        return this.exchange;
    }

    public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
        ++this.rulesFired;
    }
}

