/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.PropertyAccessor;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.OptimizerFactory;

public class LiteralDeepPropertyNode
extends ASTNode {
    private Object literal;

    public LiteralDeepPropertyNode(char[] expr, int fields, Object literal) {
        super(expr, fields);
        this.literal = literal;
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.accessor != null) {
            return this.valRet(this.accessor.getValue(this.literal, thisValue, factory));
        }
        AccessorOptimizer aO = OptimizerFactory.getThreadAccessorOptimizer();
        this.accessor = aO.optimizeAccessor(this.name, this.literal, thisValue, factory, false);
        return this.valRet(aO.getResultOptPass());
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return PropertyAccessor.get(this.name, this.literal, factory, thisValue);
    }
}

