/*
 * Decompiled with CFR 0.152.
 */
package org.drools.brms.server.rules;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.drools.base.ClassTypeResolver;
import org.drools.brms.client.modeldriven.SuggestionCompletionEngine;
import org.drools.brms.server.util.DataEnumLoader;
import org.drools.brms.server.util.SuggestionCompletionEngineBuilder;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.ParserError;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FieldTemplateDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.dsl.DSLMapping;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DSLMappingFile;
import org.drools.rule.MapBackedClassLoader;
import org.drools.util.asm.ClassFieldInspector;

public class SuggestionCompletionLoader {
    private final SuggestionCompletionEngineBuilder builder = new SuggestionCompletionEngineBuilder();
    private final DrlParser parser = new DrlParser();
    private final MapBackedClassLoader loader;
    protected List errors = new ArrayList();
    final ClassTypeResolver resolver;

    public SuggestionCompletionLoader() {
        this(null);
    }

    public SuggestionCompletionLoader(ClassLoader classLoader) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.loader = new MapBackedClassLoader(classLoader);
        this.resolver = new ClassTypeResolver(new HashSet(), (ClassLoader)this.loader);
    }

    public SuggestionCompletionEngine getSuggestionEngine(String header, List jars, List dsls) {
        return this.getSuggestionEngine(header, jars, dsls, Collections.EMPTY_LIST);
    }

    public SuggestionCompletionEngine getSuggestionEngine(String header, List jars, List dsls, List dataEnums) {
        this.builder.newCompletionEngine();
        if (!header.trim().equals("")) {
            this.processPackageHeader(header, jars);
        }
        this.populateDSLSentences(dsls);
        SuggestionCompletionEngine sce = this.builder.getInstance();
        this.populateDateEnums(dataEnums, sce);
        Arrays.sort(sce.factTypes);
        return sce;
    }

    private void populateDateEnums(List dataEnums, SuggestionCompletionEngine sce) {
        Iterator iter = dataEnums.iterator();
        while (iter.hasNext()) {
            String enumFile = (String)iter.next();
            DataEnumLoader enumLoader = new DataEnumLoader(enumFile);
            if (enumLoader.hasErrors()) {
                this.errors.addAll(enumLoader.getErrors());
                continue;
            }
            sce.dataEnumLists.putAll(enumLoader.getData());
        }
    }

    private void processPackageHeader(String header, List jars) {
        PackageDescr pkgDescr;
        try {
            pkgDescr = this.parser.parse(header);
        }
        catch (DroolsParserException e1) {
            throw new IllegalStateException("Serious error, unable to validate package.");
        }
        if (this.parser.hasErrors()) {
            Iterator iter = this.parser.getErrors().iterator();
            while (iter.hasNext()) {
                ParserError element = (ParserError)iter.next();
                this.errors.add(element.getMessage());
            }
        }
        this.populateModelInfo(pkgDescr, jars);
        this.populateGlobalInfo(pkgDescr, jars);
    }

    private void populateDSLSentences(List dsls) {
        Iterator it = dsls.iterator();
        while (it.hasNext()) {
            DSLMappingFile file = (DSLMappingFile)it.next();
            DSLMapping mapping = file.getMapping();
            Iterator entries = mapping.getEntries().iterator();
            while (entries.hasNext()) {
                DSLMappingEntry entry = (DSLMappingEntry)entries.next();
                if (entry.getSection() == DSLMappingEntry.CONDITION) {
                    this.builder.addDSLConditionSentence(entry.getMappingKey());
                    continue;
                }
                if (entry.getSection() != DSLMappingEntry.CONSEQUENCE) continue;
                this.builder.addDSLActionSentence(entry.getMappingKey());
            }
        }
    }

    private void populateGlobalInfo(PackageDescr pkgDescr, List jars) {
        Iterator it = pkgDescr.getGlobals().iterator();
        while (it.hasNext()) {
            GlobalDescr global = (GlobalDescr)it.next();
            try {
                String shortTypeName = this.getShortNameOfClass(global.getType());
                if (!this.builder.hasFieldsForType(shortTypeName)) {
                    Class clazz = this.loadClass(global.getType(), jars);
                    this.loadClassFields(clazz, shortTypeName);
                    this.builder.addGlobalType(global.getIdentifier(), shortTypeName);
                }
                this.builder.addGlobalType(global.getIdentifier(), shortTypeName);
            }
            catch (IOException e) {
                this.errors.add("Error while inspecting class for global: " + global.getType() + " error message: " + e.getMessage());
            }
        }
    }

    private void populateModelInfo(PackageDescr pkgDescr, List jars) {
        Iterator it = pkgDescr.getImports().iterator();
        while (it.hasNext()) {
            ImportDescr imp = (ImportDescr)it.next();
            String className = imp.getTarget();
            this.resolver.addImport(className);
            Class clazz = this.loadClass(className, jars);
            if (clazz == null) continue;
            try {
                String shortTypeName = this.getShortNameOfClass(clazz.getName());
                this.loadClassFields(clazz, shortTypeName);
                this.builder.addFactType(shortTypeName);
            }
            catch (IOException e) {
                this.errors.add("Error while inspecting the class: " + className + ". The error was: " + e.getMessage());
            }
        }
        this.populateFactTemplateTypes(pkgDescr, this.resolver);
    }

    private void populateFactTemplateTypes(PackageDescr pkgDescr, ClassTypeResolver resolver) {
        Iterator it = pkgDescr.getFactTemplates().iterator();
        while (it.hasNext()) {
            FactTemplateDescr templ = (FactTemplateDescr)it.next();
            String factType = templ.getName();
            this.builder.addFactType(factType);
            Object[] fields = new String[templ.getFields().size()];
            int index = 0;
            Iterator fieldsIt = templ.getFields().iterator();
            while (fieldsIt.hasNext()) {
                FieldTemplateDescr fieldDescr = (FieldTemplateDescr)fieldsIt.next();
                fields[index++] = fieldDescr.getName();
                String fieldType = fieldDescr.getClassType();
                Class fieldTypeClass = null;
                try {
                    fieldTypeClass = resolver.resolveType(fieldType);
                }
                catch (ClassNotFoundException e) {
                    this.errors.add("Fact template field type not found: " + fieldType);
                }
                this.builder.addFieldType(factType + "." + fieldDescr.getName(), this.getFieldType(fieldTypeClass));
            }
            Arrays.sort(fields);
            this.builder.addFieldsForType(factType, (String[])fields);
        }
    }

    private Class loadClass(String className, List jars) {
        Class clazz = null;
        try {
            clazz = this.resolver.resolveType(className);
        }
        catch (ClassNotFoundException e1) {
            try {
                this.addJars(jars);
                clazz = this.resolver.resolveType(className);
            }
            catch (Exception e) {
                this.errors.add("Class not found: " + className);
            }
        }
        return clazz;
    }

    private void loadClassFields(Class clazz, String shortTypeName) throws IOException {
        if (clazz == null) {
            return;
        }
        ClassFieldInspector inspector = new ClassFieldInspector(clazz);
        Object[] fields = inspector.getFieldNames().keySet().toArray(new String[inspector.getFieldNames().size()]);
        Arrays.sort(fields);
        fields = this.removeIrrelevantFields((String[])fields);
        this.builder.addFieldsForType(shortTypeName, (String[])fields);
        for (int i = 0; i < fields.length; ++i) {
            Class type = (Class)inspector.getFieldTypes().get(fields[i]);
            String fieldType = this.getFieldType(type);
            this.builder.addFieldType(shortTypeName + "." + (String)fields[i], fieldType);
        }
    }

    String getShortNameOfClass(String clazz) {
        return clazz.substring(clazz.lastIndexOf(46) + 1);
    }

    String[] removeIrrelevantFields(String[] fields) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (field.equals("class") || field.equals("hashCode") || field.equals("toString")) continue;
            result.add(field);
        }
        return result.toArray(new String[result.size()]);
    }

    private void addJars(List jars) throws IOException {
        Iterator it = jars.iterator();
        while (it.hasNext()) {
            JarInputStream jis = (JarInputStream)it.next();
            JarEntry entry = null;
            byte[] buf = new byte[1024];
            int len = 0;
            while ((entry = jis.getNextJarEntry()) != null) {
                if (entry.isDirectory()) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((len = jis.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
                this.loader.addResource(entry.getName(), out.toByteArray());
            }
        }
    }

    private String getFieldType(Class type) {
        String fieldType = null;
        if (type != null) {
            fieldType = type.isPrimitive() && type != Boolean.TYPE ? "Numeric" : (Number.class.isAssignableFrom(type) ? "Numeric" : (String.class.isAssignableFrom(type) ? "String" : (Collection.class.isAssignableFrom(type) ? "Collection" : (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type) ? "Boolean" : (Comparable.class.isAssignableFrom(type) ? "Comparable" : "Object")))));
        }
        return fieldType;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List getErrors() {
        return this.errors;
    }
}

