/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.AbstractParser;
import org.mvel.CompileException;
import org.mvel.PropertyAccessException;
import org.mvel.UnresolveablePropertyException;
import org.mvel.ast.ContextDeepPropertyNode;
import org.mvel.ast.LiteralDeepPropertyNode;
import org.mvel.ast.LiteralNode;
import org.mvel.ast.ThisValDeepPropertyNode;
import org.mvel.ast.ThisValNode;
import org.mvel.ast.VarPropertyNode;
import org.mvel.ast.VariableDeepPropertyNode;
import org.mvel.integration.VariableResolverFactory;

public class PropertyASTNode
extends ASTNode {
    private transient ASTNode wrappedNode;

    public PropertyASTNode(char[] expr, int start, int end, int fields) {
        super(expr, start, end, fields);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.wrappedNode != null) {
            return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
        }
        return this.initializePropertyNode(ctx, thisValue, factory);
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return super.getReducedValue(ctx, thisValue, factory);
    }

    private Object initializePropertyNode(Object ctx, Object thisValue, VariableResolverFactory factory) {
        String s;
        if ((this.fields & 0x10000) != 0) {
            this.literal = new String(this.name);
            this.wrappedNode = new LiteralNode(this.literal);
            return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
        }
        if ((this.fields & 1) != 0) {
            if ((this.fields & 0x4000) != 0) {
                this.wrappedNode = new ThisValNode(this.name, this.fields);
                return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
            }
            this.wrappedNode = new LiteralNode(this.literal);
            return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
        }
        if ((this.fields & 2) != 0) {
            Object sa;
            String s2 = this.getAbsoluteRootElement();
            if (AbstractParser.LITERALS.containsKey(s2)) {
                Class<?> clazz;
                Object literal = AbstractParser.LITERALS.get(s2);
                try {
                    clazz = Class.forName("org.mvel.util.ThisLiteral");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (literal == clazz) {
                    this.wrappedNode = new ThisValDeepPropertyNode(this.name, this.fields);
                    return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
                }
                this.wrappedNode = new LiteralDeepPropertyNode(this.name, this.fields, literal);
                return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
            }
            if (factory != null && factory.isResolveable(s2)) {
                this.wrappedNode = new VariableDeepPropertyNode(this.name, this.fields);
                return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
            }
            if (ctx != null) {
                try {
                    this.wrappedNode = new ContextDeepPropertyNode(this.name, this.fields);
                    return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
                }
                catch (CompileException literal) {
                    // empty catch block
                }
            }
            if ((sa = this.tryStaticAccess(ctx, factory)) == null) {
                throw new PropertyAccessException("unable to resolve token: " + new String(this.name));
            }
            this.wrappedNode = new LiteralNode(sa);
            return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
        }
        if (factory != null && factory.isResolveable(s = this.getAbsoluteName())) {
            if (s.length() < this.name.length) {
                this.wrappedNode = new VariableDeepPropertyNode(this.name, this.fields);
                return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
            }
            this.wrappedNode = new VarPropertyNode(this.name, this.fields, s);
            return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
        }
        if (ctx != null) {
            try {
                this.wrappedNode = new ContextDeepPropertyNode(this.name, this.fields);
                return this.wrappedNode.getReducedValueAccelerated(ctx, thisValue, factory);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw new UnresolveablePropertyException(this, (Throwable)e);
            }
        }
        if (this.isOperator()) {
            throw new CompileException("incomplete statement");
        }
        throw new UnresolveablePropertyException(this);
    }

    public ASTNode getWrappedNode() {
        return this.wrappedNode;
    }
}

