/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.util;

import org.mvel.ASTLinkedList;
import org.mvel.ASTNode;
import org.mvel.Operator;
import org.mvel.ast.And;
import org.mvel.ast.BinaryOperation;
import org.mvel.ast.EndOfStatement;
import org.mvel.ast.Or;
import org.mvel.debug.DebugTools;

public class CompilerTools {
    public static ASTLinkedList optimizeAST(ASTLinkedList astLinkedList, boolean secondPassOptimization) {
        ASTNode tkOp2;
        ASTNode tkOp;
        ASTNode tk;
        ASTLinkedList optimizedAst = new ASTLinkedList();
        while (astLinkedList.hasMoreNodes()) {
            tk = astLinkedList.nextNode();
            if (tk.getFields() == -1) {
                optimizedAst.addTokenNode(tk);
                continue;
            }
            if (astLinkedList.hasMoreNodes()) {
                tkOp = astLinkedList.nextNode();
                if (tkOp.getFields() == -1) {
                    optimizedAst.addTokenNode(tk);
                    if (tk instanceof EndOfStatement) {
                        astLinkedList.setCurrentNode(tkOp);
                        continue;
                    }
                    optimizedAst.addTokenNode(tkOp);
                    continue;
                }
                if (tkOp.isOperator() && tkOp.getOperator() < 20) {
                    int op2;
                    int op = tkOp.getOperator();
                    BinaryOperation bo = new BinaryOperation(op, tk, astLinkedList.nextNode());
                    tkOp2 = null;
                    while (astLinkedList.hasMoreNodes() && (tkOp2 = astLinkedList.nextNode()).isOperator() && tkOp2.getFields() != -1 && (op2 = tkOp2.getOperator().intValue()) < 20) {
                        if (Operator.PTABLE[op2] > Operator.PTABLE[op]) {
                            bo.setRightMost(new BinaryOperation(op2, bo.getRightMost(), astLinkedList.nextNode()));
                        } else if (Operator.PTABLE[op2] == Operator.PTABLE[op]) {
                            bo.setRight(new BinaryOperation(op2, bo.getRight(), astLinkedList.nextNode()));
                        } else {
                            System.out.println(String.valueOf(DebugTools.getOperatorName(op2)) + " < " + DebugTools.getOperatorName(op));
                            bo = new BinaryOperation(op2, bo, astLinkedList.nextNode());
                        }
                        op = op2;
                        tkOp = tkOp2;
                    }
                    optimizedAst.addTokenNode(bo);
                    if (tkOp2 == null || tkOp2 == tkOp) continue;
                    optimizedAst.addTokenNode(tkOp2);
                    continue;
                }
                optimizedAst.addTokenNode(tk);
                if (tk instanceof EndOfStatement) {
                    astLinkedList.setCurrentNode(tkOp);
                    continue;
                }
                optimizedAst.addTokenNode(tkOp);
                continue;
            }
            optimizedAst.addTokenNode(tk);
        }
        if (secondPassOptimization) {
            astLinkedList = optimizedAst;
            astLinkedList.reset();
            optimizedAst = new ASTLinkedList();
            while (astLinkedList.hasMoreNodes()) {
                tk = astLinkedList.nextNode();
                if (tk.getFields() == -1) {
                    optimizedAst.addTokenNode(tk);
                    continue;
                }
                if (astLinkedList.hasMoreNodes()) {
                    tkOp = astLinkedList.nextNode();
                    if (tkOp.getFields() == -1) {
                        optimizedAst.addTokenNode(tk);
                        if (tk instanceof EndOfStatement) {
                            astLinkedList.setCurrentNode(tkOp);
                        }
                        optimizedAst.addTokenNode(tkOp);
                        continue;
                    }
                    if (tkOp.isOperator() && (tkOp.getOperator() == 20 || tkOp.getOperator() == 21)) {
                        tkOp2 = null;
                        ASTNode bool = null;
                        switch (tkOp.getOperator()) {
                            case 20: {
                                bool = new And(tk, astLinkedList.nextNode());
                                break;
                            }
                            case 21: {
                                bool = new Or(tk, astLinkedList.nextNode());
                            }
                        }
                        while (astLinkedList.hasMoreNodes() && (tkOp2 = astLinkedList.nextNode()).isOperator() && (tkOp2.isOperator(new Integer(20)) || tkOp2.isOperator(new Integer(21)))) {
                            tkOp = tkOp2;
                            switch (tkOp.getOperator()) {
                                case 20: {
                                    bool = new And(bool, astLinkedList.nextNode());
                                    break;
                                }
                                case 21: {
                                    bool = new Or(bool, astLinkedList.nextNode());
                                }
                            }
                        }
                        optimizedAst.addTokenNode(bool);
                        if (tkOp2 == null || tkOp2 == tkOp) continue;
                        optimizedAst.addTokenNode(tkOp2);
                        continue;
                    }
                    optimizedAst.addTokenNode(tk);
                    if (tk instanceof EndOfStatement) {
                        astLinkedList.setCurrentNode(tkOp);
                    }
                    optimizedAst.addTokenNode(tkOp);
                    continue;
                }
                optimizedAst.addTokenNode(tk);
            }
        }
        return optimizedAst;
    }

    public static boolean isOperator(char item) {
        switch (item) {
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case '<': 
            case '>': 
            case '^': 
            case '|': {
                return true;
            }
        }
        return false;
    }
}

