/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.drools;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.common.util.MessageUtil;
import org.apache.servicemix.drools.DroolsExecutionContext;
import org.drools.RuleBase;
import org.drools.compiler.RuleBaseLoader;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsEndpoint
extends ProviderEndpoint {
    private RuleBase ruleBase;
    private Resource ruleBaseResource;
    private URL ruleBaseURL;
    private NamespaceContext namespaceContext;
    private QName defaultTargetService;
    private String defaultTargetURI;
    private Map<String, Object> globals;
    private List<Object> assertedObjects;
    private boolean autoReply;
    private ConcurrentMap<String, DroolsExecutionContext> pending = new ConcurrentHashMap<String, DroolsExecutionContext>(){

        @Override
        public DroolsExecutionContext remove(Object key) {
            DroolsExecutionContext context = (DroolsExecutionContext)((Object)super.remove(key));
            if (context != null) {
                context.update();
                context.stop();
            }
            return context;
        }
    };

    public DroolsEndpoint() {
    }

    public DroolsEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public DroolsEndpoint(ServiceUnit su, QName service, String endpoint) {
        super(su, service, endpoint);
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public Resource getRuleBaseResource() {
        return this.ruleBaseResource;
    }

    public void setRuleBaseResource(Resource ruleBaseResource) {
        this.ruleBaseResource = ruleBaseResource;
    }

    public URL getRuleBaseURL() {
        return this.ruleBaseURL;
    }

    public void setRuleBaseURL(URL ruleBaseURL) {
        this.ruleBaseURL = ruleBaseURL;
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public Map<String, Object> getGlobals() {
        return this.globals;
    }

    public void setGlobals(Map<String, Object> variables) {
        this.globals = variables;
    }

    public boolean isAutoReply() {
        return this.autoReply;
    }

    public void setAutoReply(boolean autoReply) {
        this.autoReply = autoReply;
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.ruleBase == null && this.ruleBaseResource == null && this.ruleBaseURL == null) {
            throw new DeploymentException("Property ruleBase, ruleBaseResource or ruleBaseURL must be set");
        }
    }

    public void start() throws Exception {
        super.start();
        if (this.ruleBase == null) {
            InputStream is = null;
            try {
                if (this.ruleBaseResource != null) {
                    is = this.ruleBaseResource.getInputStream();
                } else if (this.ruleBaseURL != null) {
                    is = this.ruleBaseURL.openStream();
                } else {
                    throw new IllegalArgumentException("Property ruleBase, ruleBaseResource or ruleBaseURL must be set");
                }
                RuleBaseLoader loader = RuleBaseLoader.getInstance();
                this.ruleBase = loader.loadFromReader((Reader)new InputStreamReader(is));
            }
            catch (Exception e) {
                throw new JBIException((Throwable)e);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            this.handleProviderExchange(exchange);
        } else {
            this.handleConsumerExchange(exchange);
        }
    }

    private void handleConsumerExchange(MessageExchange exchange) throws MessagingException {
        String correlation = (String)exchange.getProperty("org.apache.servicemix.drools.correlation_id");
        DroolsExecutionContext drools = (DroolsExecutionContext)((Object)this.pending.get(correlation));
        if (drools != null) {
            MessageExchange original = drools.getExchange();
            if (exchange.getStatus() == ExchangeStatus.DONE) {
                this.done(original);
            } else if (exchange.getStatus() == ExchangeStatus.ERROR) {
                this.fail(original, exchange.getError());
            } else {
                if (exchange.getFault() != null) {
                    MessageUtil.transferFaultToFault((MessageExchange)exchange, (MessageExchange)original);
                } else {
                    MessageUtil.transferOutToOut((MessageExchange)exchange, (MessageExchange)original);
                }
                this.sendSync(original);
                this.done(exchange);
            }
        } else {
            this.logger.debug((Object)("No pending exchange found for " + correlation + ", no additional rules will be triggered"));
        }
    }

    private void handleProviderExchange(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            this.drools(exchange);
        } else {
            this.pending.remove(exchange.getExchangeId());
        }
    }

    public static String getCorrelationId(MessageExchange exchange) {
        Object correlation = exchange.getProperty("org.apache.servicemix.correlationId");
        if (correlation == null) {
            return exchange.getExchangeId();
        }
        return correlation.toString();
    }

    protected void drools(MessageExchange exchange) throws Exception {
        DroolsExecutionContext drools = this.startDroolsExecutionContext(exchange);
        if (drools.getRulesFired() < 1) {
            if (this.getDefaultTargetService() == null) {
                this.fail(exchange, new Exception("No rules have handled the exchange. Check your rule base."));
            } else {
                drools.getHelper().route(this.getDefaultRouteURI());
            }
        } else {
            if (drools.isExchangeHandled() && exchange instanceof InOnly) {
                this.pending.remove(exchange.getExchangeId());
            }
            if (!drools.isExchangeHandled() && this.autoReply) {
                this.reply(exchange, drools);
            }
        }
    }

    private void reply(MessageExchange exchange, DroolsExecutionContext drools) throws Exception {
        Fault fault = exchange.getFault();
        if (fault != null) {
            drools.getHelper().fault(fault.getContent());
        } else if (this.isOutCapable(exchange)) {
            NormalizedMessage message = exchange.getMessage("out");
            if (message == null) {
                message = exchange.getMessage("in");
            }
            drools.getHelper().answer(message.getContent());
        } else if (exchange instanceof InOnly) {
            this.done(exchange);
        }
    }

    private boolean isOutCapable(MessageExchange exchange) {
        return exchange instanceof InOptionalOut || exchange instanceof InOut;
    }

    private DroolsExecutionContext startDroolsExecutionContext(MessageExchange exchange) {
        DroolsExecutionContext drools = new DroolsExecutionContext(this, exchange);
        this.pending.put(exchange.getExchangeId(), drools);
        drools.start();
        return drools;
    }

    public QName getDefaultTargetService() {
        return this.defaultTargetService;
    }

    public void setDefaultTargetService(QName defaultTargetService) {
        this.defaultTargetService = defaultTargetService;
    }

    public String getDefaultTargetURI() {
        return this.defaultTargetURI;
    }

    public void setDefaultTargetURI(String defaultTargetURI) {
        this.defaultTargetURI = defaultTargetURI;
    }

    public List<Object> getAssertedObjects() {
        return this.assertedObjects;
    }

    public void setAssertedObjects(List<Object> assertedObjects) {
        this.assertedObjects = assertedObjects;
    }

    public String getDefaultRouteURI() {
        if (this.defaultTargetURI != null) {
            return this.defaultTargetURI;
        }
        if (this.defaultTargetService != null) {
            String nsURI = this.defaultTargetService.getNamespaceURI();
            String sep = nsURI.indexOf("/") > 0 ? "/" : ":";
            return "service:" + nsURI + sep + this.defaultTargetService.getLocalPart();
        }
        return null;
    }

    protected void send(MessageExchange me) throws MessagingException {
        if (me.getStatus() != ExchangeStatus.ACTIVE) {
            this.pending.remove(me.getExchangeId());
        }
        super.send(me);
    }
}

