/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import org.drools.FactException;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.ContextEntry;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.PropagationContext;
import org.drools.util.FactEntry;
import org.drools.util.FactHashTable;
import org.drools.util.Iterator;

public class AlphaNode
extends ObjectSource
implements ObjectSinkNode,
NodeMemory {
    private static final long serialVersionUID = 400L;
    private final AlphaNodeFieldConstraint constraint;
    private ObjectSinkNode previousObjectSinkNode;
    private ObjectSinkNode nextObjectSinkNode;
    private boolean objectMemoryEnabled;
    private boolean objectMemoryAllowed;

    public AlphaNode(int id, AlphaNodeFieldConstraint constraint, ObjectSource objectSource, BuildContext context) {
        super(id, objectSource, context.getRuleBase().getConfiguration().getAlphaNodeHashingThreshold());
        this.constraint = constraint;
        this.objectMemoryAllowed = context.isAlphaMemoryAllowed();
        this.objectMemoryEnabled = this.objectMemoryAllowed ? context.getRuleBase().getConfiguration().isAlphaMemory() : false;
    }

    public AlphaNodeFieldConstraint getConstraint() {
        return this.constraint;
    }

    public void attach() {
        this.objectSource.addObjectSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        if (this.objectMemoryAllowed) {
            this.setObjectMemoryEnabled(true);
        }
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.objectSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) throws FactException {
        AlphaMemory memory = (AlphaMemory)workingMemory.getNodeMemory(this);
        if (this.constraint.isAllowed(handle.getObject(), workingMemory, memory.context)) {
            if (this.isObjectMemoryEnabled()) {
                memory.facts.add(handle, false);
            }
            this.sink.propagateAssertObject(handle, context, workingMemory);
        }
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        boolean propagate = true;
        AlphaMemory memory = (AlphaMemory)workingMemory.getNodeMemory(this);
        propagate = this.isObjectMemoryEnabled() ? memory.facts.remove(handle) : this.constraint.isAllowed(handle.getObject(), workingMemory, memory.context);
        if (propagate) {
            this.sink.propagateRetractObject(handle, context, workingMemory, true);
        }
    }

    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        AlphaMemory memory = (AlphaMemory)workingMemory.getNodeMemory(this);
        if (!this.isObjectMemoryEnabled()) {
            ObjectSinkUpdateAdapter adapter = new ObjectSinkUpdateAdapter(sink, this.constraint, memory.context);
            this.objectSource.updateSink(adapter, context, workingMemory);
        } else {
            Iterator it = memory.facts.iterator();
            FactEntry entry = (FactEntry)it.next();
            while (entry != null) {
                sink.assertObject(entry.getFactHandle(), context, workingMemory);
                entry = (FactEntry)it.next();
            }
        }
    }

    public void remove(RuleRemovalContext context, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeObjectSink((ObjectSink)((Object)node));
        }
        if (!this.isInUse()) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                workingMemories[i].clearNodeMemory(this);
            }
        }
        this.objectSource.remove(context, this, workingMemories);
    }

    public void setObjectMemoryAllowed(boolean objectMemoryAllowed) {
        this.objectMemoryAllowed = objectMemoryAllowed;
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemoryEnabled;
    }

    public void setObjectMemoryEnabled(boolean objectMemoryEnabled) {
        this.objectMemoryEnabled = objectMemoryEnabled;
    }

    public Object createMemory(RuleBaseConfiguration config) {
        AlphaMemory memory = new AlphaMemory();
        memory.context = this.constraint.createContextEntry();
        if (this.objectMemoryEnabled) {
            memory.facts = new FactHashTable();
        }
        return memory;
    }

    protected void addObjectSink(ObjectSink objectSink) {
        super.addObjectSink(objectSink);
    }

    public String toString() {
        return "[AlphaNode(" + this.id + ") constraint=" + this.constraint + "]";
    }

    public int hashCode() {
        return this.objectSource.hashCode() * 17 + (this.constraint != null ? this.constraint.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AlphaNode)) {
            return false;
        }
        AlphaNode other = (AlphaNode)object;
        return this.objectSource.equals(other.objectSource) && this.constraint.equals(other.constraint);
    }

    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }

    private static class ObjectSinkUpdateAdapter
    implements ObjectSink {
        private final ObjectSink sink;
        private final AlphaNodeFieldConstraint constraint;
        private final ContextEntry alphaContext;

        public ObjectSinkUpdateAdapter(ObjectSink sink, AlphaNodeFieldConstraint constraint, ContextEntry context) {
            this.sink = sink;
            this.constraint = constraint;
            this.alphaContext = context;
        }

        public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
            if (this.constraint.isAllowed(handle.getObject(), workingMemory, this.alphaContext)) {
                this.sink.assertObject(handle, context, workingMemory);
            }
        }

        public void modifyObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("ObjectSinkUpdateAdapter onlys supports assertObject method calls");
        }

        public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("ObjectSinkUpdateAdapter onlys supports assertObject method calls");
        }

        public boolean isObjectMemoryEnabled() {
            throw new UnsupportedOperationException("ObjectSinkUpdateAdapter have no Object memory");
        }

        public void setObjectMemoryEnabled(boolean objectMemoryEnabled) {
            throw new UnsupportedOperationException("ObjectSinkUpdateAdapter have no Object memory");
        }
    }

    public static class AlphaMemory
    implements Serializable {
        private static final long serialVersionUID = -5852576405010023458L;
        public FactHashTable facts;
        public ContextEntry context;
    }
}

