/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.instance.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.drools.common.InternalRuleBase;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.definition.process.NodeContainer;
import org.drools.runtime.process.EventListener;
import org.drools.workflow.core.WorkflowProcess;
import org.drools.workflow.core.node.CompositeNode;
import org.drools.workflow.core.node.EventNode;
import org.drools.workflow.core.node.EventNodeInterface;
import org.drools.workflow.core.node.StartNode;
import org.drools.workflow.instance.NodeInstance;
import org.drools.workflow.instance.NodeInstanceContainer;
import org.drools.workflow.instance.WorkflowProcessInstance;
import org.drools.workflow.instance.impl.NodeInstanceFactory;
import org.drools.workflow.instance.impl.NodeInstanceFactoryRegistry;
import org.drools.workflow.instance.impl.NodeInstanceImpl;
import org.drools.workflow.instance.node.EndNodeInstance;
import org.drools.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.drools.workflow.instance.node.EventNodeInstanceInterface;
import org.drools.workflow.instance.node.StateBasedNodeInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeNodeInstance
extends StateBasedNodeInstance
implements NodeInstanceContainer,
EventNodeInstanceInterface,
EventBasedNodeInstanceInterface {
    private static final long serialVersionUID = 510L;
    private final List<NodeInstance> nodeInstances = new ArrayList<NodeInstance>();
    private long nodeInstanceCounter = 0L;

    @Override
    public void setProcessInstance(WorkflowProcessInstance processInstance) {
        super.setProcessInstance(processInstance);
        this.registerExternalEventNodeListeners();
    }

    private void registerExternalEventNodeListeners() {
        for (Node node : this.getCompositeNode().getNodes()) {
            if (!(node instanceof EventNode) || !"external".equals(((EventNode)node).getScope())) continue;
            this.getProcessInstance().addEventListener(((EventNode)node).getType(), new EventListener(){

                public String[] getEventTypes() {
                    return null;
                }

                public void signalEvent(String type, Object event) {
                }
            }, true);
        }
    }

    protected CompositeNode getCompositeNode() {
        return (CompositeNode)this.getNode();
    }

    @Override
    public NodeContainer getNodeContainer() {
        return this.getCompositeNode();
    }

    @Override
    public void internalTrigger(org.drools.runtime.process.NodeInstance from, String type) {
        super.internalTrigger(from, type);
        CompositeNode.NodeAndType nodeAndType = this.getCompositeNode().internalGetLinkedIncomingNode(type);
        if (nodeAndType != null) {
            List connections = nodeAndType.getNode().getIncomingConnections(nodeAndType.getType());
            for (Connection connection : connections) {
                if (!(connection.getFrom() instanceof CompositeNode.CompositeNodeStart) || from != null && ((CompositeNode.CompositeNodeStart)connection.getFrom()).getInNode().getId() != from.getNodeId()) continue;
                NodeInstance nodeInstance = this.getNodeInstance(connection.getFrom());
                nodeInstance.trigger(null, nodeAndType.getType());
                return;
            }
        } else {
            boolean found = false;
            for (Node node : this.getCompositeNode().getNodes()) {
                StartNode startNode;
                if (!(node instanceof StartNode) || (startNode = (StartNode)node).getTriggers() != null && !startNode.getTriggers().isEmpty()) continue;
                NodeInstance nodeInstance = this.getNodeInstance(startNode.getTo().getTo());
                nodeInstance.trigger(null, "DROOLS_DEFAULT");
                found = true;
            }
            if (found) {
                return;
            }
        }
        if (this.isLinkedIncomingNodeRequired()) {
            throw new IllegalArgumentException("Could not find start for composite node: " + type);
        }
    }

    protected boolean isLinkedIncomingNodeRequired() {
        return true;
    }

    public void triggerCompleted(String outType) {
        boolean cancelRemainingInstances = this.getCompositeNode().isCancelRemainingInstances();
        this.triggerCompleted(outType, cancelRemainingInstances);
        if (cancelRemainingInstances) {
            while (!this.nodeInstances.isEmpty()) {
                NodeInstance nodeInstance = this.nodeInstances.get(0);
                nodeInstance.cancel();
            }
        }
    }

    @Override
    public void cancel() {
        while (!this.nodeInstances.isEmpty()) {
            NodeInstance nodeInstance = this.nodeInstances.get(0);
            nodeInstance.cancel();
        }
        super.cancel();
    }

    @Override
    public void addNodeInstance(NodeInstance nodeInstance) {
        ((NodeInstanceImpl)nodeInstance).setId(this.nodeInstanceCounter++);
        this.nodeInstances.add(nodeInstance);
    }

    @Override
    public void removeNodeInstance(NodeInstance nodeInstance) {
        this.nodeInstances.remove(nodeInstance);
    }

    public Collection<org.drools.runtime.process.NodeInstance> getNodeInstances() {
        return new ArrayList<org.drools.runtime.process.NodeInstance>(this.getNodeInstances(false));
    }

    @Override
    public Collection<NodeInstance> getNodeInstances(boolean recursive) {
        List<NodeInstance> result = this.nodeInstances;
        if (recursive) {
            result = new ArrayList<NodeInstance>(result);
            for (NodeInstance nodeInstance : this.nodeInstances) {
                if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
                result.addAll(((NodeInstanceContainer)((Object)nodeInstance)).getNodeInstances(true));
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    public NodeInstance getNodeInstance(long nodeInstanceId) {
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getId() != nodeInstanceId) continue;
            return nodeInstance;
        }
        return null;
    }

    @Override
    public NodeInstance getFirstNodeInstance(long nodeId) {
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            return nodeInstance;
        }
        return null;
    }

    @Override
    public NodeInstance getNodeInstance(Node node) {
        if (node instanceof CompositeNode.CompositeNodeStart) {
            CompositeNodeStartInstance nodeInstance = new CompositeNodeStartInstance();
            nodeInstance.setNodeId(node.getId());
            nodeInstance.setNodeInstanceContainer(this);
            nodeInstance.setProcessInstance(this.getProcessInstance());
            return nodeInstance;
        }
        if (node instanceof CompositeNode.CompositeNodeEnd) {
            CompositeNodeEndInstance nodeInstance = new CompositeNodeEndInstance();
            nodeInstance.setNodeId(node.getId());
            nodeInstance.setNodeInstanceContainer(this);
            nodeInstance.setProcessInstance(this.getProcessInstance());
            return nodeInstance;
        }
        NodeInstanceFactoryRegistry nodeRegistry = ((InternalRuleBase)this.getProcessInstance().getWorkingMemory().getRuleBase()).getConfiguration().getProcessNodeInstanceFactoryRegistry();
        NodeInstanceFactory conf = nodeRegistry.getProcessNodeInstanceFactory(node);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        NodeInstanceImpl nodeInstance = (NodeInstanceImpl)conf.getNodeInstance(node, this.getProcessInstance(), this);
        if (nodeInstance == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        return nodeInstance;
    }

    @Override
    public void signalEvent(String type, Object event) {
        super.signalEvent(type, event);
        for (Node node : this.getCompositeNode().getNodes()) {
            if (!(node instanceof EventNodeInterface) || !((EventNodeInterface)node).acceptsEvent(type, event)) continue;
            if (node instanceof EventNode && ((EventNode)node).getFrom() == null) {
                EventNodeInstanceInterface eventNodeInstance = (EventNodeInstanceInterface)((Object)this.getNodeInstance(node));
                eventNodeInstance.signalEvent(type, event);
                continue;
            }
            List<NodeInstance> nodeInstances = this.getNodeInstances(node.getId());
            if (nodeInstances == null || nodeInstances.isEmpty()) continue;
            for (NodeInstance nodeInstance : nodeInstances) {
                ((EventNodeInstanceInterface)((Object)nodeInstance)).signalEvent(type, event);
            }
        }
    }

    public List<NodeInstance> getNodeInstances(long nodeId) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            result.add(nodeInstance);
        }
        return result;
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstanceInterface)) continue;
            ((EventBasedNodeInstanceInterface)((Object)nodeInstance)).addEventListeners();
        }
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstanceInterface)) continue;
            ((EventBasedNodeInstanceInterface)((Object)nodeInstance)).removeEventListeners();
        }
    }

    @Override
    public void nodeInstanceCompleted(NodeInstance nodeInstance, String outType) {
        if (nodeInstance instanceof EndNodeInstance) {
            if (((WorkflowProcess)this.getProcessInstance().getProcess()).isAutoComplete() && this.nodeInstances.isEmpty()) {
                this.triggerCompleted("DROOLS_DEFAULT");
            }
        } else {
            throw new IllegalArgumentException("Completing a node instance that has no outgoing connection not supported.");
        }
    }

    public class CompositeNodeEndInstance
    extends NodeInstanceImpl {
        private static final long serialVersionUID = 510L;

        public CompositeNode.CompositeNodeEnd getCompositeNodeEnd() {
            return (CompositeNode.CompositeNodeEnd)this.getNode();
        }

        public void internalTrigger(org.drools.runtime.process.NodeInstance from, String type) {
            this.triggerCompleted();
        }

        public void triggerCompleted() {
            CompositeNodeInstance.this.triggerCompleted(this.getCompositeNodeEnd().getOutType());
        }
    }

    public class CompositeNodeStartInstance
    extends NodeInstanceImpl {
        private static final long serialVersionUID = 510L;

        public CompositeNode.CompositeNodeStart getCompositeNodeStart() {
            return (CompositeNode.CompositeNodeStart)this.getNode();
        }

        public void internalTrigger(org.drools.runtime.process.NodeInstance from, String type) {
            this.triggerCompleted();
        }

        public void triggerCompleted() {
            this.triggerCompleted("DROOLS_DEFAULT", true);
        }
    }
}

