/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.concurrent.atomic.AtomicReference;
import org.drools.common.InternalFactHandle;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.Iterator;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;

public class ConcurrentRightTupleList
implements RightTupleMemory,
Entry {
    private static final long serialVersionUID = 510L;
    public AtomicReference<Entry> previous;
    public AtomicReference<Entry> next;
    public AtomicReference<RightTuple> first;
    public AtomicReference<RightTuple> last;
    private final int hashCode;
    private final AbstractHashTable.Index index;

    public ConcurrentRightTupleList() {
        this.hashCode = 0;
        this.index = null;
        this.previous = new AtomicReference();
        this.next = new AtomicReference();
        this.first = new AtomicReference();
        this.last = new AtomicReference();
    }

    public ConcurrentRightTupleList(AbstractHashTable.Index index, int hashCode) {
        this.index = index;
        this.hashCode = hashCode;
    }

    public RightTuple getFirst(LeftTuple leftTuple, InternalFactHandle factHandle) {
        return this.first.get();
    }

    public RightTuple getFirst(RightTuple rightTuple) {
        return this.first.get();
    }

    public RightTuple getLast(LeftTuple leftTuple) {
        return this.last.get();
    }

    public void add(RightTuple rightTuple) {
        if (this.last != null) {
            this.last.get().setNext(rightTuple);
            rightTuple.setPrevious(this.last.get());
            this.last.set(rightTuple);
        } else {
            this.first.set(rightTuple);
            this.last.set(rightTuple);
        }
    }

    public void remove(RightTuple rightTuple) {
        RightTuple previous = (RightTuple)rightTuple.getPrevious();
        RightTuple next = (RightTuple)rightTuple.getNext();
        if (previous != null && next != null) {
            previous.setNext(next);
            next.setPrevious(previous);
        } else if (next != null) {
            this.first.set(next);
            next.setPrevious(null);
        } else if (previous != null) {
            this.last.set(previous);
            previous.setNext(null);
        } else {
            this.last = null;
            this.first = null;
        }
        rightTuple.setPrevious(null);
        rightTuple.setNext(null);
    }

    public RightTuple get(InternalFactHandle handle) {
        for (RightTuple current = this.first.get(); current != null; current = (RightTuple)current.getNext()) {
            if (handle != current.getFactHandle()) continue;
            return current;
        }
        return null;
    }

    public boolean contains(InternalFactHandle handle) {
        return this.get(handle) != null;
    }

    public RightTuple get(RightTuple rightTuple) {
        InternalFactHandle handle = rightTuple.getFactHandle();
        for (RightTuple current = this.first.get(); current != null; current = (RightTuple)current.getNext()) {
            if (handle != current.getFactHandle()) continue;
            return current;
        }
        return null;
    }

    public boolean contains(RightTuple rightTuple) {
        return this.get(rightTuple) != null;
    }

    public int size() {
        int i = 0;
        RightTuple current = this.first.get();
        while (current != null) {
            current = (RightTuple)current.getNext();
            ++i;
        }
        return i;
    }

    public Iterator iterator() {
        throw new UnsupportedOperationException();
    }

    public boolean matches(Object object, int objectHashCode) {
        return this.hashCode == objectHashCode && this.index.equal(this.first.get().getFactHandle().getObject(), object);
    }

    public boolean matches(LeftTuple tuple, int tupleHashCode) {
        return this.hashCode == tupleHashCode && this.index.equal(this.first.get().getFactHandle().getObject(), tuple);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        ConcurrentRightTupleList other = (ConcurrentRightTupleList)object;
        return this.hashCode == other.hashCode && this.index == other.index;
    }

    public Entry getNext() {
        return this.next.get();
    }

    public void setNext(Entry next) {
        this.next.set(next);
    }

    public boolean isIndexed() {
        return this.index != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (RightTuple rightTuple = this.first.get(); rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
            builder.append(rightTuple);
        }
        return builder.toString();
    }

    public Entry[] toArray() {
        throw new UnsupportedOperationException("method is not implemented yet");
    }
}

