/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.Iterator;
import org.drools.core.util.StringUtils;
import org.drools.lang.descr.ProcessDescr;
import org.drools.rule.ImportDeclaration;
import org.drools.rule.builder.ProcessBuildContext;
import org.drools.rule.builder.ProcessClassBuilder;

public class JavaProcessClassBuilder
implements ProcessClassBuilder {
    public String buildRule(ProcessBuildContext context) {
        if (context.getMethods().isEmpty()) {
            return null;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder buffer = new StringBuilder();
        buffer.append("package " + context.getPkg().getName() + ";" + lineSeparator);
        for (ImportDeclaration decl : context.getPkg().getImports().values()) {
            buffer.append("import " + decl.getTarget() + ";" + lineSeparator);
        }
        Iterator it = context.getPkg().getStaticImports().iterator();
        while (it.hasNext()) {
            buffer.append("import static " + it.next() + ";" + lineSeparator);
        }
        ProcessDescr processDescr = context.getProcessDescr();
        buffer.append("public class " + StringUtils.ucFirst((String)processDescr.getClassName()) + " {" + lineSeparator);
        buffer.append("    private static final long serialVersionUID = 510l;" + lineSeparator);
        int size = context.getMethods().size();
        for (int i = 0; i < size; ++i) {
            buffer.append(context.getMethods().get(i) + lineSeparator);
        }
        String[] lines = buffer.toString().split(lineSeparator);
        buffer.append("}");
        return buffer.toString();
    }
}

