/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import org.drools.RuleBaseConfiguration;
import org.drools.base.DroolsQuery;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.core.util.ArrayUtils;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashMap;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Accumulate;
import org.drools.rule.Behavior;
import org.drools.rule.ContextEntry;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.PropagationContext;

public class AccumulateNode
extends BetaNode {
    private static final long serialVersionUID = 510L;
    private boolean unwrapRightObject;
    private Accumulate accumulate;
    private AlphaNodeFieldConstraint[] resultConstraints;
    private BetaConstraints resultBinder;

    public AccumulateNode() {
    }

    public AccumulateNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, AlphaNodeFieldConstraint[] resultConstraints, BetaConstraints sourceBinder, BetaConstraints resultBinder, Behavior[] behaviors, Accumulate accumulate, boolean unwrapRightObject, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, sourceBinder, behaviors);
        this.resultBinder = resultBinder;
        this.resultConstraints = resultConstraints;
        this.accumulate = accumulate;
        this.unwrapRightObject = unwrapRightObject;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.unwrapRightObject = in.readBoolean();
        this.accumulate = (Accumulate)in.readObject();
        this.resultConstraints = (AlphaNodeFieldConstraint[])in.readObject();
        this.resultBinder = (BetaConstraints)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.unwrapRightObject);
        out.writeObject(this.accumulate);
        out.writeObject(this.resultConstraints);
        out.writeObject(this.resultBinder);
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        AccumulateContext accresult = new AccumulateContext();
        boolean useLeftMemory = true;
        if (this.tupleMemoryEnabled) {
            memory.betaMemory.getLeftTupleMemory().add(leftTuple);
            memory.betaMemory.getCreatedHandles().put(leftTuple, accresult, false);
        } else {
            Object object = ((InternalFactHandle)context.getFactHandle()).getObject();
            if (memory.betaMemory.getLeftTupleMemory() != null && (!(object instanceof DroolsQuery) || ((DroolsQuery)object).isOpen())) {
                memory.betaMemory.getLeftTupleMemory().add(leftTuple);
                memory.betaMemory.getCreatedHandles().put(leftTuple, accresult, false);
            } else {
                useLeftMemory = false;
            }
        }
        accresult.context = this.accumulate.createContext();
        this.accumulate.init(memory.workingMemoryContext, accresult.context, leftTuple, workingMemory);
        this.constraints.updateFromTuple(memory.betaMemory.getContext(), workingMemory, leftTuple);
        for (RightTuple rightTuple = memory.betaMemory.getRightTupleMemory().getFirst(leftTuple, (InternalFactHandle)context.getFactHandle()); rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
            InternalFactHandle handle = rightTuple.getFactHandle();
            if (!this.constraints.isAllowedCachedLeft(memory.betaMemory.getContext(), handle)) continue;
            this.addMatch(leftTuple, rightTuple, null, null, workingMemory, memory, accresult, useLeftMemory);
        }
        this.constraints.resetTuple(memory.betaMemory.getContext());
        this.evaluateResultConstraints(ActivitySource.LEFT, leftTuple, context, workingMemory, memory, accresult, useLeftMemory);
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        memory.betaMemory.getLeftTupleMemory().remove(leftTuple);
        AccumulateContext accctx = (AccumulateContext)memory.betaMemory.getCreatedHandles().remove(leftTuple);
        this.removePreviousMatchesForLeftTuple(leftTuple, workingMemory, memory, accctx);
        if (accctx.propagated) {
            this.sink.propagateRetractLeftTupleDestroyRightTuple(leftTuple, context, workingMemory);
        } else {
            workingMemory.getFactHandleFactory().destroyFactHandle(accctx.result.getFactHandle());
        }
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        RightTuple rightTuple = new RightTuple(factHandle, this);
        if (!this.behavior.assertRightTuple(memory.betaMemory.getBehaviorContext(), rightTuple, workingMemory)) {
            rightTuple.unlinkFromRightParent();
            return;
        }
        memory.betaMemory.getRightTupleMemory().add(rightTuple);
        if (memory.betaMemory.getLeftTupleMemory() == null || memory.betaMemory.getLeftTupleMemory().size() == 0) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.betaMemory.getContext(), workingMemory, factHandle);
        for (LeftTuple leftTuple = memory.betaMemory.getLeftTupleMemory().getFirst(rightTuple); leftTuple != null; leftTuple = (LeftTuple)leftTuple.getNext()) {
            if (!this.constraints.isAllowedCachedRight(memory.betaMemory.getContext(), leftTuple)) continue;
            AccumulateContext accctx = (AccumulateContext)memory.betaMemory.getCreatedHandles().get(leftTuple);
            this.addMatch(leftTuple, rightTuple, null, null, workingMemory, memory, accctx, true);
            this.evaluateResultConstraints(ActivitySource.RIGHT, leftTuple, context, workingMemory, memory, accctx, true);
        }
        this.constraints.resetFactHandle(memory.betaMemory.getContext());
    }

    public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        InternalFactHandle origin = (InternalFactHandle)context.getFactHandleOrigin();
        if (context.getType() == 5) {
            ((PropagationContextImpl)context).setFactHandle(null);
        }
        this.behavior.retractRightTuple(memory.betaMemory.getBehaviorContext(), rightTuple, workingMemory);
        memory.betaMemory.getRightTupleMemory().remove(rightTuple);
        this.removePreviousMatchesForRightTuple(rightTuple, context, workingMemory, memory, rightTuple.firstChild);
        if (context.getType() == 5) {
            ((PropagationContextImpl)context).setFactHandle(origin);
        }
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        AccumulateContext accctx = (AccumulateContext)memory.betaMemory.getCreatedHandles().get(leftTuple);
        memory.betaMemory.getLeftTupleMemory().remove(leftTuple);
        memory.betaMemory.getLeftTupleMemory().add(leftTuple);
        this.constraints.updateFromTuple(memory.betaMemory.getContext(), workingMemory, leftTuple);
        LeftTuple childLeftTuple = this.getFirstMatch(leftTuple, accctx, false);
        RightTupleMemory rightMemory = memory.betaMemory.getRightTupleMemory();
        RightTuple rightTuple = rightMemory.getFirst(leftTuple, (InternalFactHandle)context.getFactHandle());
        if (childLeftTuple != null && rightMemory.isIndexed() && rightTuple != rightMemory.getFirst(childLeftTuple.getRightParent())) {
            this.removePreviousMatchesForLeftTuple(leftTuple, workingMemory, memory, accctx);
            childLeftTuple = null;
        }
        if (rightTuple != null) {
            if (childLeftTuple == null) {
                while (rightTuple != null) {
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (this.constraints.isAllowedCachedLeft(memory.betaMemory.getContext(), handle)) {
                        this.addMatch(leftTuple, rightTuple, null, null, workingMemory, memory, accctx, true);
                    }
                    rightTuple = (RightTuple)rightTuple.getNext();
                }
            } else {
                boolean isDirty = false;
                while (rightTuple != null) {
                    LeftTuple temp;
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (this.constraints.isAllowedCachedLeft(memory.betaMemory.getContext(), handle)) {
                        if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                            this.addMatch(leftTuple, rightTuple, childLeftTuple, null, workingMemory, memory, accctx, true);
                        } else {
                            temp = childLeftTuple.getLeftParentNext();
                            childLeftTuple.reAddRight();
                            childLeftTuple = temp;
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
                        temp = childLeftTuple.getLeftParentNext();
                        this.removeMatch(rightTuple, childLeftTuple, workingMemory, memory, accctx, false);
                        childLeftTuple = temp;
                        isDirty = !this.accumulate.supportsReverse();
                    }
                    rightTuple = (RightTuple)rightTuple.getNext();
                }
                if (isDirty) {
                    this.reaccumulateForLeftTuple(leftTuple, workingMemory, memory, accctx);
                }
            }
        }
        this.constraints.resetTuple(memory.betaMemory.getContext());
        this.evaluateResultConstraints(ActivitySource.LEFT, leftTuple, context, workingMemory, memory, accctx, true);
    }

    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        memory.betaMemory.getRightTupleMemory().remove(rightTuple);
        memory.betaMemory.getRightTupleMemory().add(rightTuple);
        if (memory.betaMemory.getLeftTupleMemory() == null || memory.betaMemory.getLeftTupleMemory().size() == 0) {
            return;
        }
        LeftTuple childLeftTuple = rightTuple.firstChild;
        LeftTupleMemory leftMemory = memory.betaMemory.getLeftTupleMemory();
        LeftTuple leftTuple = leftMemory.getFirst(rightTuple);
        this.constraints.updateFromFactHandle(memory.betaMemory.getContext(), workingMemory, rightTuple.getFactHandle());
        if (childLeftTuple != null && leftMemory.isIndexed() && leftTuple != leftMemory.getFirst(childLeftTuple.getLeftParent())) {
            this.removePreviousMatchesForRightTuple(rightTuple, context, workingMemory, memory, childLeftTuple);
            childLeftTuple = null;
        }
        if (leftTuple != null) {
            if (childLeftTuple == null) {
                while (leftTuple != null) {
                    if (this.constraints.isAllowedCachedRight(memory.betaMemory.getContext(), leftTuple)) {
                        AccumulateContext accctx = (AccumulateContext)memory.betaMemory.getCreatedHandles().get(leftTuple);
                        this.addMatch(leftTuple, rightTuple, null, null, workingMemory, memory, accctx, true);
                        this.evaluateResultConstraints(ActivitySource.RIGHT, leftTuple, context, workingMemory, memory, accctx, true);
                    }
                    leftTuple = (LeftTuple)leftTuple.getNext();
                }
            } else {
                while (leftTuple != null) {
                    if (this.constraints.isAllowedCachedRight(memory.betaMemory.getContext(), leftTuple)) {
                        AccumulateContext accctx = (AccumulateContext)memory.betaMemory.getCreatedHandles().get(leftTuple);
                        LeftTuple temp = null;
                        if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                            temp = childLeftTuple.getRightParentNext();
                            childLeftTuple.reAddLeft();
                            this.removeMatch(rightTuple, childLeftTuple, workingMemory, memory, accctx, true);
                            childLeftTuple = childLeftTuple.getRightParentNext();
                        }
                        this.addMatch(leftTuple, rightTuple, null, childLeftTuple, workingMemory, memory, accctx, true);
                        if (temp != null) {
                            childLeftTuple = temp;
                        }
                        this.evaluateResultConstraints(ActivitySource.RIGHT, leftTuple, context, workingMemory, memory, accctx, true);
                    } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                        LeftTuple temp = childLeftTuple.getRightParentNext();
                        AccumulateContext accctx = (AccumulateContext)memory.betaMemory.getCreatedHandles().get(leftTuple);
                        this.removeMatch(rightTuple, childLeftTuple, workingMemory, memory, accctx, true);
                        this.evaluateResultConstraints(ActivitySource.RIGHT, leftTuple, context, workingMemory, memory, accctx, true);
                        childLeftTuple = temp;
                    }
                    leftTuple = (LeftTuple)leftTuple.getNext();
                }
            }
        }
        this.constraints.resetFactHandle(memory.betaMemory.getContext());
    }

    private void evaluateResultConstraints(ActivitySource source, LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, AccumulateMemory memory, AccumulateContext accctx, boolean useLeftMemory) {
        Object result = this.accumulate.getResult(memory.workingMemoryContext, accctx.context, leftTuple, workingMemory);
        if (accctx.result == null) {
            InternalFactHandle handle = workingMemory.getFactHandleFactory().newFactHandle(result, workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.getEntryPoint(), result), workingMemory, null);
            accctx.result = new RightTuple(handle, this);
        } else {
            accctx.result.getFactHandle().setObject(result);
        }
        boolean isAllowed = result != null;
        int length = this.resultConstraints.length;
        for (int i = 0; isAllowed && i < length; ++i) {
            if (this.resultConstraints[i].isAllowed(accctx.result.getFactHandle(), workingMemory, memory.alphaContexts[i])) continue;
            isAllowed = false;
        }
        if (isAllowed) {
            this.resultBinder.updateFromTuple(memory.resultsContext, workingMemory, leftTuple);
            if (!this.resultBinder.isAllowedCachedLeft(memory.resultsContext, accctx.result.getFactHandle())) {
                isAllowed = false;
            }
            this.resultBinder.resetTuple(memory.resultsContext);
        }
        if (accctx.propagated) {
            LeftTuple[] matchings = this.splitList(leftTuple, accctx, false);
            if (isAllowed) {
                if (ActivitySource.LEFT.equals((Object)source)) {
                    this.sink.propagateModifyChildLeftTuple(leftTuple.firstChild, leftTuple, context, workingMemory, useLeftMemory);
                } else {
                    this.sink.propagateModifyChildLeftTuple(leftTuple.firstChild, accctx.result, context, workingMemory, useLeftMemory);
                }
            } else {
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
                accctx.propagated = false;
            }
            this.restoreList(leftTuple, matchings);
        } else if (isAllowed) {
            LeftTuple[] matchings = this.splitList(leftTuple, accctx, false);
            this.sink.propagateAssertLeftTuple(leftTuple, accctx.result, null, null, context, workingMemory, useLeftMemory);
            accctx.propagated = true;
            this.restoreList(leftTuple, matchings);
        }
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        Iterator tupleIter = memory.betaMemory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            AccumulateContext accctx = (AccumulateContext)memory.betaMemory.getCreatedHandles().get(leftTuple);
            if (accctx.propagated) {
                LeftTuple[] matchings = this.splitList(leftTuple, accctx, true);
                sink.assertLeftTuple(new LeftTuple(leftTuple, accctx.result, null, null, sink, true), context, workingMemory);
                this.restoreList(leftTuple, matchings);
            }
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    protected void doRemove(InternalWorkingMemory workingMemory, AccumulateMemory memory) {
        Iterator it = memory.betaMemory.getCreatedHandles().iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            AccumulateContext ctx = (AccumulateContext)entry.getValue();
            workingMemory.getFactHandleFactory().destroyFactHandle(ctx.result.getFactHandle());
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode() ^ this.accumulate.hashCode() ^ this.resultBinder.hashCode() ^ ArrayUtils.hashCode(this.resultConstraints);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AccumulateNode)) {
            return false;
        }
        AccumulateNode other = (AccumulateNode)object;
        if (!(this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints))) {
            return false;
        }
        return this.accumulate.equals(other.accumulate) && this.resultBinder.equals(other.resultBinder) && Arrays.equals(this.resultConstraints, other.resultConstraints);
    }

    public Object createMemory(RuleBaseConfiguration config) {
        AccumulateMemory memory = new AccumulateMemory();
        memory.betaMemory = this.constraints.createBetaMemory(config);
        memory.workingMemoryContext = this.accumulate.createWorkingMemoryContext();
        memory.resultsContext = this.resultBinder.createContext();
        memory.alphaContexts = new ContextEntry[this.resultConstraints.length];
        for (int i = 0; i < this.resultConstraints.length; ++i) {
            memory.alphaContexts[i] = this.resultConstraints[i].createContextEntry();
        }
        memory.betaMemory.setBehaviorContext(this.behavior.createBehaviorContext());
        return memory;
    }

    public short getType() {
        return 6;
    }

    private void addMatch(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, InternalWorkingMemory workingMemory, AccumulateMemory memory, AccumulateContext accresult, boolean useLeftMemory) {
        LeftTuple tuple = leftTuple;
        InternalFactHandle handle = rightTuple.getFactHandle();
        if (this.unwrapRightObject) {
            tuple = (LeftTuple)handle.getObject();
            handle = tuple.getLastHandle();
        }
        this.accumulate.accumulate(memory.workingMemoryContext, accresult.context, tuple, handle, workingMemory);
        if (useLeftMemory) {
            new LeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, this, true);
        }
    }

    private void removeMatch(RightTuple rightTuple, LeftTuple match, InternalWorkingMemory workingMemory, AccumulateMemory memory, AccumulateContext accctx, boolean reaccumulate) {
        LeftTuple leftTuple = match.getLeftParent();
        if (match != null) {
            match.unlinkFromLeftParent();
            match.unlinkFromRightParent();
        }
        InternalFactHandle handle = rightTuple.getFactHandle();
        LeftTuple tuple = leftTuple;
        if (this.unwrapRightObject) {
            tuple = (LeftTuple)handle.getObject();
            handle = tuple.getLastHandle();
        }
        if (this.accumulate.supportsReverse()) {
            this.accumulate.reverse(memory.workingMemoryContext, accctx.context, tuple, handle, workingMemory);
        } else if (reaccumulate) {
            this.reaccumulateForLeftTuple(leftTuple, workingMemory, memory, accctx);
        }
    }

    private void reaccumulateForLeftTuple(LeftTuple leftTuple, InternalWorkingMemory workingMemory, AccumulateMemory memory, AccumulateContext accctx) {
        this.accumulate.init(memory.workingMemoryContext, accctx.context, leftTuple, workingMemory);
        for (LeftTuple childMatch = this.getFirstMatch(leftTuple, accctx, false); childMatch != null; childMatch = childMatch.getLeftParentNext()) {
            InternalFactHandle childHandle = childMatch.getRightParent().getFactHandle();
            LeftTuple tuple = leftTuple;
            if (this.unwrapRightObject) {
                tuple = (LeftTuple)childHandle.getObject();
                childHandle = tuple.getLastHandle();
            }
            this.accumulate.accumulate(memory.workingMemoryContext, accctx.context, tuple, childHandle, workingMemory);
        }
    }

    private void removePreviousMatchesForLeftTuple(LeftTuple leftTuple, InternalWorkingMemory workingMemory, AccumulateMemory memory, AccumulateContext accctx) {
        LeftTuple[] matchings = this.splitList(leftTuple, accctx, false);
        for (LeftTuple match = matchings[0]; match != null; match = match.getLeftParentNext()) {
            match.unlinkFromRightParent();
        }
        this.accumulate.init(memory.workingMemoryContext, accctx.context, leftTuple, workingMemory);
    }

    private void removePreviousMatchesForRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, AccumulateMemory memory, LeftTuple firstChild) {
        LeftTuple match = firstChild;
        while (match != null) {
            LeftTuple tmp = match.getRightParentNext();
            LeftTuple parent = match.getLeftParent();
            AccumulateContext accctx = (AccumulateContext)memory.betaMemory.getCreatedHandles().get(parent);
            this.removeMatch(rightTuple, match, workingMemory, memory, accctx, true);
            this.evaluateResultConstraints(ActivitySource.RIGHT, parent, context, workingMemory, memory, accctx, true);
            match = tmp;
        }
    }

    protected LeftTuple[] splitList(LeftTuple parent, AccumulateContext accctx, boolean isUpdatingSink) {
        LeftTuple[] matchings = new LeftTuple[2];
        matchings[0] = this.getFirstMatch(parent, accctx, isUpdatingSink);
        LeftTuple leftTuple = matchings[1] = matchings[0] != null ? parent.lastChild : null;
        if (matchings[0] != null) {
            if (parent.firstChild == matchings[0]) {
                parent.firstChild = null;
            }
            parent.lastChild = matchings[0].getLeftParentPrevious();
            if (parent.lastChild != null) {
                parent.lastChild.setLeftParentNext(null);
                matchings[0].setLeftParentPrevious(null);
            }
        }
        return matchings;
    }

    private void restoreList(LeftTuple parent, LeftTuple[] matchings) {
        if (parent.firstChild == null) {
            parent.firstChild = matchings[0];
            parent.lastChild = matchings[1];
        } else if (matchings[0] != null) {
            parent.lastChild.setLeftParentNext(matchings[0]);
            matchings[0].setLeftParentPrevious(parent.lastChild);
            parent.lastChild = matchings[1];
        }
    }

    private LeftTuple getFirstMatch(LeftTuple leftTuple, AccumulateContext accctx, boolean isUpdatingSink) {
        LeftTuple child = leftTuple.firstChild;
        if (accctx.propagated) {
            int target = isUpdatingSink ? this.sink.size() - 1 : this.sink.size();
            for (int i = 0; i < target; ++i) {
                child = child.getLeftParentNext();
            }
        }
        return child;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ActivitySource {
        LEFT,
        RIGHT;

    }

    public static class AccumulateContext
    implements Externalizable {
        public Serializable context;
        public RightTuple result;
        public boolean propagated;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.context = (Serializable)in.readObject();
            this.result = (RightTuple)in.readObject();
            this.propagated = in.readBoolean();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.context);
            out.writeObject(this.result);
            out.writeBoolean(this.propagated);
        }
    }

    public static class AccumulateMemory
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        public Object workingMemoryContext;
        public BetaMemory betaMemory;
        public ContextEntry[] resultsContext;
        public ContextEntry[] alphaContexts;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.workingMemoryContext = in.readObject();
            this.betaMemory = (BetaMemory)in.readObject();
            this.resultsContext = (ContextEntry[])in.readObject();
            this.alphaContexts = (ContextEntry[])in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.workingMemoryContext);
            out.writeObject(this.betaMemory);
            out.writeObject(this.resultsContext);
            out.writeObject(this.alphaContexts);
        }
    }
}

