/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.drools.PackageIntegrationException;
import org.drools.RuleBaseConfiguration;
import org.drools.WorkingMemory;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.InternalRuleBase;
import org.drools.common.ObjectInputStreamWithLoader;
import org.drools.rule.CompositePackageClassLoader;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Package;
import org.drools.rule.PackageCompilationData;
import org.drools.rule.Rule;
import org.drools.spi.FactHandleFactory;

public abstract class AbstractRuleBase
implements InternalRuleBase,
Externalizable {
    protected RuleBaseConfiguration config;
    protected Map pkgs;
    protected transient CompositePackageClassLoader packageClassLoader;
    protected FactHandleFactory factHandleFactory;
    protected Map globals;
    protected transient Map workingMemories;
    protected static final Object PRESENT = new Object();

    public AbstractRuleBase(RuleBaseConfiguration ruleBaseConfiguration, FactHandleFactory factHandleFactory) {
        this.config = ruleBaseConfiguration != null ? ruleBaseConfiguration : new RuleBaseConfiguration();
        this.config.makeImmutable();
        this.factHandleFactory = factHandleFactory;
        this.packageClassLoader = new CompositePackageClassLoader(Thread.currentThread().getContextClassLoader());
        this.pkgs = new HashMap();
        this.globals = new HashMap();
        this.workingMemories = new WeakHashMap();
    }

    public void doWriteExternal(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        objectOutput.writeObject(this.pkgs);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.factHandleFactory);
        objectOutputStream.writeObject(this.globals);
        objectOutputStream.writeObject(this.config);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeObject(objectArray[i]);
        }
        objectOutput.writeObject(byteArrayOutputStream.toByteArray());
    }

    public void doReadExternal(ObjectInput objectInput, Object[] objectArray) throws IOException, ClassNotFoundException {
        this.pkgs = (Map)objectInput.readObject();
        this.packageClassLoader = new CompositePackageClassLoader(Thread.currentThread().getContextClassLoader());
        Object object = this.pkgs.values().iterator();
        while (object.hasNext()) {
            this.packageClassLoader.addClassLoader(((Package)object.next()).getPackageCompilationData().getClassLoader());
        }
        object = (byte[])objectInput.readObject();
        ObjectInputStreamWithLoader objectInputStreamWithLoader = new ObjectInputStreamWithLoader(new ByteArrayInputStream((byte[])object), this.packageClassLoader);
        this.factHandleFactory = (FactHandleFactory)objectInputStreamWithLoader.readObject();
        this.globals = (Map)objectInputStreamWithLoader.readObject();
        this.config = (RuleBaseConfiguration)objectInputStreamWithLoader.readObject();
        this.workingMemories = new WeakHashMap();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = objectInputStreamWithLoader.readObject();
        }
    }

    public WorkingMemory newWorkingMemory() {
        return this.newWorkingMemory(true);
    }

    public abstract WorkingMemory newWorkingMemory(boolean var1);

    public void disposeWorkingMemory(WorkingMemory workingMemory) {
        this.workingMemories.remove(workingMemory);
    }

    public FactHandleFactory getFactHandleFactory() {
        return this.factHandleFactory;
    }

    public FactHandleFactory newFactHandleFactory() {
        return this.factHandleFactory.newInstance();
    }

    public Package[] getPackages() {
        return this.pkgs.values().toArray(new Package[this.pkgs.size()]);
    }

    public Map getGlobals() {
        return this.globals;
    }

    public void addPackage(Package package_) throws PackageIntegrationException {
        Serializable serializable;
        Rule[] ruleArray;
        package_.checkValidity();
        Package package_2 = (Package)this.pkgs.get(package_.getName());
        Object object = this.workingMemories.keySet().iterator();
        while (object.hasNext()) {
            ruleArray = (AbstractWorkingMemory)object.next();
            ruleArray.getLock().lock();
        }
        if (package_2 != null) {
            this.mergePackage(package_2, package_);
        } else {
            this.pkgs.put(package_.getName(), package_);
        }
        object = package_.getGlobals();
        ruleArray = object.keySet().iterator();
        while (ruleArray.hasNext()) {
            String string = (String)ruleArray.next();
            serializable = (Class)object.get(string);
            if (!this.globals.containsKey(string) || this.globals.get(string).equals(serializable)) continue;
            throw new PackageIntegrationException(package_2);
        }
        this.globals.putAll(object);
        ruleArray = package_.getRules();
        for (int i = 0; i < ruleArray.length; ++i) {
            this.addRule(ruleArray[i]);
        }
        this.packageClassLoader.addClassLoader(package_.getPackageCompilationData().getClassLoader());
        Iterator iterator = this.workingMemories.keySet().iterator();
        while (iterator.hasNext()) {
            serializable = (AbstractWorkingMemory)iterator.next();
            ((AbstractWorkingMemory)serializable).fireAllRules();
            ((AbstractWorkingMemory)serializable).getLock().unlock();
        }
    }

    private void mergePackage(Package package_, Package package_2) throws PackageIntegrationException {
        Map map = package_.getGlobals();
        List list = package_.getImports();
        PackageCompilationData packageCompilationData = package_.getPackageCompilationData();
        PackageCompilationData packageCompilationData2 = package_2.getPackageCompilationData();
        String[] stringArray = packageCompilationData2.list();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            packageCompilationData.write(stringArray[i], packageCompilationData2.read(stringArray[i]));
        }
        list.addAll(package_2.getImports());
        packageCompilationData.putAllInvokers(packageCompilationData2.getInvokers());
        Iterator iterator = package_2.getGlobals().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Class clazz = (Class)map.get(string);
            if (!map.containsKey(string) || map.get(string).equals(clazz)) continue;
            throw new PackageIntegrationException("Unable to merge new Package", package_2);
        }
        map.putAll(package_2.getGlobals());
    }

    protected void addRule(Rule rule) throws InvalidPatternException {
        if (!rule.isValid()) {
            throw new IllegalArgumentException("The rule called " + rule.getName() + " is not valid. Check for compile errors reported.");
        }
    }

    public void removePackage(String string) {
        Object object;
        Package package_ = (Package)this.pkgs.get(string);
        Rule[] ruleArray = this.workingMemories.keySet().iterator();
        while (ruleArray.hasNext()) {
            AbstractWorkingMemory abstractWorkingMemory = (AbstractWorkingMemory)ruleArray.next();
            abstractWorkingMemory.getLock().lock();
        }
        ruleArray = package_.getRules();
        for (int i = 0; i < ruleArray.length; ++i) {
            this.removeRule(ruleArray[i]);
        }
        this.packageClassLoader.removeClassLoader(package_.getPackageCompilationData().getClassLoader());
        package_.clear();
        HashSet hashSet = new HashSet();
        Iterator<Object> iterator = this.pkgs.values().iterator();
        while (iterator.hasNext()) {
            object = (Package)iterator.next();
            if (object == package_) continue;
            hashSet.addAll(((Package)object).getGlobals().keySet());
        }
        iterator = package_.getGlobals().keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (hashSet.contains(object)) continue;
            this.globals.remove(object);
        }
        this.pkgs.remove(package_.getName());
        iterator = this.workingMemories.keySet().iterator();
        while (iterator.hasNext()) {
            object = (AbstractWorkingMemory)iterator.next();
            ((AbstractWorkingMemory)object).getLock().unlock();
        }
    }

    public void removeRule(String string, String string2) {
        AbstractWorkingMemory abstractWorkingMemory;
        Package package_ = (Package)this.pkgs.get(string);
        Rule rule = package_.getRule(string2);
        Iterator iterator = this.workingMemories.keySet().iterator();
        while (iterator.hasNext()) {
            abstractWorkingMemory = (AbstractWorkingMemory)iterator.next();
            abstractWorkingMemory.getLock().lock();
        }
        this.removeRule(rule);
        package_.removeRule(rule);
        iterator = this.workingMemories.keySet().iterator();
        while (iterator.hasNext()) {
            abstractWorkingMemory = (AbstractWorkingMemory)iterator.next();
            abstractWorkingMemory.getLock().unlock();
        }
    }

    protected abstract void removeRule(Rule var1);

    protected void addWorkingMemory(WorkingMemory workingMemory, boolean bl) {
        if (bl) {
            this.workingMemories.put(workingMemory, PRESENT);
        }
    }

    public Set getWorkingMemories() {
        return this.workingMemories.keySet();
    }

    public RuleBaseConfiguration getConfiguration() {
        return this.config;
    }

    public WorkingMemory newWorkingMemory(InputStream inputStream) throws IOException, ClassNotFoundException {
        return this.newWorkingMemory(inputStream, true);
    }

    public WorkingMemory newWorkingMemory(InputStream inputStream, boolean bl) throws IOException, ClassNotFoundException {
        ObjectInputStreamWithLoader objectInputStreamWithLoader = new ObjectInputStreamWithLoader(inputStream, this.packageClassLoader);
        AbstractWorkingMemory abstractWorkingMemory = (AbstractWorkingMemory)objectInputStreamWithLoader.readObject();
        abstractWorkingMemory.setRuleBase(this);
        return abstractWorkingMemory;
    }
}

