/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import org.drools.RuntimeDroolsException;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.rule.Declaration;
import org.drools.spi.FieldConstraint;
import org.drools.spi.PredicateExpression;
import org.drools.spi.Tuple;

public class PredicateConstraint
implements FieldConstraint {
    private static final long serialVersionUID = -103424847725754568L;
    private PredicateExpression expression;
    private final Declaration declaration;
    private final Declaration[] requiredDeclarations;
    private static final Declaration[] EMPTY_DECLARATIONS = new Declaration[0];

    public PredicateConstraint(PredicateExpression predicateExpression, Declaration declaration) {
        this(predicateExpression, declaration, null);
    }

    public PredicateConstraint(Declaration declaration, Declaration[] declarationArray) {
        this(null, declaration, declarationArray);
    }

    public PredicateConstraint(PredicateExpression predicateExpression, Declaration declaration, Declaration[] declarationArray) {
        this.expression = predicateExpression;
        this.declaration = declaration;
        this.requiredDeclarations = declarationArray == null ? EMPTY_DECLARATIONS : declarationArray;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public void setPredicateExpression(PredicateExpression predicateExpression) {
        this.expression = predicateExpression;
    }

    public PredicateExpression getPredicateExpression() {
        return this.expression;
    }

    public boolean isAllowed(InternalFactHandle internalFactHandle, Tuple tuple, WorkingMemory workingMemory) {
        try {
            return this.expression.evaluate(tuple, internalFactHandle, this.declaration, this.requiredDeclarations, workingMemory);
        }
        catch (Exception exception) {
            throw new RuntimeDroolsException(exception);
        }
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != PredicateConstraint.class) {
            return false;
        }
        PredicateConstraint predicateConstraint = (PredicateConstraint)object;
        if (this.requiredDeclarations.length != predicateConstraint.requiredDeclarations.length) {
            return false;
        }
        if (this.declaration.getColumn() != predicateConstraint.declaration.getColumn()) {
            return false;
        }
        if (!this.declaration.getExtractor().equals(predicateConstraint.declaration.getExtractor())) {
            return false;
        }
        int n = this.requiredDeclarations.length;
        for (int i = 0; i < n; ++i) {
            if (this.requiredDeclarations[i].getColumn() != predicateConstraint.requiredDeclarations[i].getColumn()) {
                return false;
            }
            if (this.requiredDeclarations[i].getExtractor().equals(predicateConstraint.requiredDeclarations[i].getExtractor())) continue;
            return false;
        }
        return this.expression.equals(predicateConstraint.expression);
    }
}

