/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.drools.util.CompositeCollection;

public class PrimitiveLongMap
implements Serializable {
    private static final long serialVersionUID = 199618748057741463L;
    private static final Object NULL = new Serializable(){
        private static final long serialVersionUID = -3636017371487047326L;
    };
    private final int indexIntervals;
    private final int intervalShifts;
    private final int midIntervalPoint;
    private final int tableSize;
    private final int shifts;
    private final int doubleShifts;
    private final Page firstPage;
    private Page lastPage;
    private int lastPageId;
    private long maxKey;
    private Page[] pageIndex;
    private int totalSize;

    public PrimitiveLongMap() {
        this(32, 8);
    }

    public PrimitiveLongMap(int n) {
        this(n, 8);
    }

    public PrimitiveLongMap(int n, int n2) {
        int n3 = 1;
        int n4 = 2;
        while (n4 < n2) {
            n4 <<= 1;
            ++n3;
        }
        this.indexIntervals = n4;
        this.intervalShifts = n3;
        n3 = 1;
        n4 = 2;
        while (n4 < n) {
            n4 <<= 1;
            ++n3;
        }
        this.tableSize = n4;
        this.shifts = n3;
        this.doubleShifts = this.shifts << 1;
        this.midIntervalPoint = this.tableSize << this.shifts << this.intervalShifts >> 1;
        this.lastPageId = 0;
        this.firstPage = new Page(null, this.lastPageId, this.tableSize);
        this.maxKey = this.lastPageId + 1 << this.doubleShifts;
        this.pageIndex = new Page[]{this.firstPage};
        this.lastPage = this.firstPage;
    }

    public Object put(long l, Object object) {
        Page page;
        Object object2;
        if (l < 0L) {
            throw new IllegalArgumentException("-ve keys not supported: " + l);
        }
        if (object == null) {
            object = NULL;
        }
        if ((object2 = (page = this.findPage(l)).put(l, object)) == null) {
            ++this.totalSize;
        }
        return object2;
    }

    public Object remove(long l) {
        if (l > this.maxKey || l < 0L) {
            return null;
        }
        Page page = this.findPage(l);
        Object object = page.put(l, null);
        if (this.lastPageId != 0 && this.lastPage.isEmpty()) {
            this.shrinkPages(this.lastPageId);
        }
        if (object != null) {
            --this.totalSize;
        }
        return object;
    }

    public Object get(long l) {
        if (l > this.maxKey || l < 0L) {
            return null;
        }
        Object object = this.findPage(l).get(l);
        if (object == NULL) {
            object = null;
        }
        return object;
    }

    public int size() {
        return this.totalSize;
    }

    public Collection values() {
        CompositeCollection compositeCollection = new CompositeCollection();
        for (Page page = this.firstPage; page != null && page.getPageId() <= this.lastPageId; page = page.getNextSibling()) {
            compositeCollection.addComposited(Arrays.asList(page.getValues()));
        }
        return compositeCollection;
    }

    public boolean containsKey(long l) {
        if (l < 0L) {
            return false;
        }
        return this.get(l) != null;
    }

    public Page expandPages(int n) {
        for (int i = this.lastPageId; i < n; ++i) {
            this.lastPage = new Page(this.lastPage, ++this.lastPageId, this.tableSize);
            if (this.lastPage.getPageId() % this.indexIntervals != 0) continue;
            int n2 = this.pageIndex.length + 1;
            this.resizeIndex(n2);
            this.pageIndex[n2 - 1] = this.lastPage;
        }
        this.maxKey = (this.lastPageId + 1 << this.doubleShifts) - 1;
        return this.lastPage;
    }

    public void shrinkPages(int n) {
        for (int i = this.lastPageId; i >= n; --i) {
            if (this.lastPageId % this.indexIntervals == 0 && this.lastPageId != 0) {
                this.resizeIndex(this.pageIndex.length - 1);
            }
            Page page = this.lastPage.getPreviousSibling();
            page.setNextSibling(null);
            this.lastPage.clear();
            this.lastPage = page;
            this.lastPageId = page.getPageId();
        }
    }

    public void resizeIndex(int n) {
        Page[] pageArray = new Page[n];
        System.arraycopy(this.pageIndex, 0, pageArray, 0, n > this.pageIndex.length ? this.pageIndex.length : n);
        this.pageIndex = pageArray;
    }

    private Page findPage(long l) {
        Page page;
        int n = (int)l >> this.doubleShifts;
        if (n == this.lastPageId) {
            page = this.lastPage;
        } else if (n == 0) {
            page = this.firstPage;
        } else if (n > this.lastPageId) {
            page = this.expandPages(n);
        } else {
            int n2 = n >> this.intervalShifts;
            if (n2 != this.pageIndex.length - 1 && l - (long)(n2 << this.intervalShifts << this.doubleShifts) > (long)this.midIntervalPoint) {
                page = this.pageIndex[n2 + 1];
                while (page.getPageId() != n) {
                    page = page.getPreviousSibling();
                }
            } else {
                page = this.pageIndex[n2];
                while (page.getPageId() != n) {
                    page = page.getNextSibling();
                }
            }
        }
        return page;
    }

    private static class Page
    implements Serializable {
        private static final long serialVersionUID = -3301899266460094468L;
        private final int pageSize;
        private final int pageId;
        private final int shifts;
        private final int tableSize;
        private Page nextSibling;
        private Page previousSibling;
        private Object[][] tables;
        private int filledSlots;

        Page(Page page, int n, int n2) {
            int n3 = 1;
            int n4 = 2;
            while (n4 < n2) {
                n4 <<= 1;
                ++n3;
            }
            this.tableSize = n4;
            this.shifts = n3;
            this.previousSibling = page;
            if (this.previousSibling != null) {
                this.previousSibling.setNextSibling(this);
            }
            this.pageId = n;
            this.pageSize = n2 << this.shifts;
        }

        public int getPageId() {
            return this.pageId;
        }

        void setNextSibling(Page page) {
            this.nextSibling = page;
        }

        public Page getNextSibling() {
            return this.nextSibling;
        }

        void setPreviousSibling(Page page) {
            this.previousSibling = page;
        }

        public Page getPreviousSibling() {
            return this.previousSibling;
        }

        public Object get(long l) {
            if (this.tables == null) {
                return null;
            }
            int n = (int)(l -= (long)(this.pageSize * this.pageId)) >> this.shifts;
            int n2 = n << this.shifts;
            return this.tables[n][(int)l - n2];
        }

        public Object put(long l, Object object) {
            if (this.tables == null) {
                this.tables = new Object[this.tableSize][this.tableSize];
            }
            int n = (int)(l -= (long)(this.pageSize * this.pageId)) >> this.shifts;
            int n2 = n << this.shifts;
            int n3 = (int)l - n2;
            Object object2 = this.tables[n][n3];
            this.tables[n][n3] = object;
            if (object2 == null && object != null) {
                ++this.filledSlots;
            } else if (object2 != null && object == null) {
                --this.filledSlots;
            }
            if (this.filledSlots == 0) {
                this.tables = null;
            }
            return object2;
        }

        Object[][] getTables() {
            return this.tables;
        }

        Object[] getValues() {
            Object[] objectArray = new Object[this.filledSlots];
            if (objectArray.length == 0) {
                return objectArray;
            }
            int n = 0;
            for (int i = 0; i < this.tableSize; ++i) {
                for (int j = 0; j < this.tableSize; ++j) {
                    Object object = this.tables[i][j];
                    if (object == null) continue;
                    if (object == NULL) {
                        object = null;
                    }
                    objectArray[n] = object;
                    ++n;
                }
            }
            return objectArray;
        }

        public boolean isEmpty() {
            return this.filledSlots == 0;
        }

        void clear() {
            this.previousSibling = null;
            this.nextSibling = null;
            this.tables = null;
        }
    }
}

