/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.drools.model;

import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.client.ServiceMixClient;
import org.apache.servicemix.client.ServiceMixClientFacade;
import org.apache.servicemix.drools.DroolsEndpoint;
import org.apache.servicemix.drools.model.Exchange;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jbi.resolver.URIResolver;
import org.apache.servicemix.jbi.util.MessageUtil;
import org.drools.FactHandle;
import org.drools.WorkingMemory;

public class JbiHelper {
    private DroolsEndpoint endpoint;
    private Exchange exchange;
    private WorkingMemory memory;
    private FactHandle exchangeFactHandle;

    public JbiHelper(DroolsEndpoint endpoint, MessageExchange exchange, WorkingMemory memory) {
        this.endpoint = endpoint;
        this.exchange = new Exchange(exchange, endpoint.getNamespaceContext());
        this.memory = memory;
        this.exchangeFactHandle = this.memory.assertObject((Object)this.exchange);
    }

    public DroolsEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ComponentContext getContext() {
        return this.endpoint.getContext();
    }

    public DeliveryChannel getChannel() throws MessagingException {
        return this.getContext().getDeliveryChannel();
    }

    public ServiceMixClient getClient() {
        return new ServiceMixClientFacade(this.getContext());
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public Log getLogger() {
        return LogFactory.getLog((String)this.memory.getRuleBase().getPackages()[0].getName());
    }

    public void route(String uri) throws MessagingException {
        MessageExchange me = this.exchange.getInternalExchange();
        NormalizedMessage in = me.getMessage("in");
        MessageExchange newMe = this.getChannel().createExchangeFactory().createExchange(me.getPattern());
        URIResolver.configureExchange((MessageExchange)newMe, (ComponentContext)this.getContext(), (String)uri);
        MessageUtil.transferToIn((NormalizedMessage)in, (MessageExchange)newMe);
        this.getChannel().sendSync(newMe);
        if (newMe.getStatus() == ExchangeStatus.DONE) {
            me.setStatus(ExchangeStatus.DONE);
            this.getChannel().send(me);
        } else if (newMe.getStatus() == ExchangeStatus.ERROR) {
            me.setStatus(ExchangeStatus.ERROR);
            me.setError(newMe.getError());
            this.getChannel().send(me);
        } else {
            if (newMe.getFault() != null) {
                MessageUtil.transferFaultToFault((MessageExchange)newMe, (MessageExchange)me);
            } else {
                MessageUtil.transferOutToOut((MessageExchange)newMe, (MessageExchange)me);
            }
            this.getChannel().sendSync(me);
        }
        this.update();
    }

    public void fault(String content) throws Exception {
        MessageExchange me = this.exchange.getInternalExchange();
        if (me instanceof InOnly) {
            me.setError(new Exception(content));
            this.getChannel().send(me);
        } else {
            Fault fault = me.createFault();
            fault.setContent((Source)new StringSource(content));
            me.setFault(fault);
            this.getChannel().sendSync(me);
        }
        this.update();
    }

    public void answer(String content) throws Exception {
        MessageExchange me = this.exchange.getInternalExchange();
        NormalizedMessage out = me.createMessage();
        out.setContent((Source)new StringSource(content));
        me.setMessage(out, "out");
        this.getChannel().sendSync(me);
        this.update();
    }

    protected void update() {
        this.memory.modifyObject(this.exchangeFactHandle, (Object)this.exchange);
    }
}

