/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.drools.support;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceContextImpl
implements NamespaceContext {
    private Map<String, String> namespaces;

    public NamespaceContextImpl() {
        this.namespaces = new LinkedHashMap<String, String>();
    }

    public NamespaceContextImpl(Map<String, String> namespaces) {
        this.namespaces = new LinkedHashMap<String, String>(namespaces);
    }

    public Map getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces.clear();
        if (namespaces != null) {
            this.namespaces.putAll(namespaces);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix argument was null");
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.namespaces.containsKey(prefix)) {
            String uri = this.namespaces.get(prefix);
            if (uri.length() == 0) {
                return null;
            }
            return uri;
        }
        return null;
    }

    @Override
    public String getPrefix(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException("nsURI was null");
        }
        if (nsURI.length() == 0) {
            throw new IllegalArgumentException("nsURI was empty");
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            String uri = entry.getValue();
            if (!uri.equals(nsURI)) continue;
            return entry.getKey();
        }
        if (nsURI.length() == 0) {
            return "";
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException("nsURI was null");
        }
        if (nsURI.length() == 0) {
            throw new IllegalArgumentException("nsURI was empty");
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return Collections.singleton("xml").iterator();
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return Collections.singleton("xmlns").iterator();
        }
        Set prefixes = null;
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            String uri = entry.getValue();
            if (!uri.equals(nsURI)) continue;
            if (prefixes == null) {
                prefixes = new HashSet();
            }
            prefixes.add(entry.getKey());
        }
        if (prefixes != null) {
            return Collections.unmodifiableSet(prefixes).iterator();
        }
        if (nsURI.length() == 0) {
            return Collections.singleton("").iterator();
        }
        prefixes = Collections.emptySet();
        return prefixes.iterator();
    }
}

