/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import org.antlr.codegen.CodeGenerator;
import org.antlr.codegen.Target;
import org.antlr.tool.Grammar;

public class CPPTarget
extends Target {
    public String escapeChar(int n) {
        switch (n) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                return "\\'";
            }
            case 34: {
                return "\\\"";
            }
        }
        if (n < 32 || n > 126) {
            if (n > 255) {
                String string = Integer.toString(n, 16);
                while (string.length() < 4) {
                    string = '0' + string;
                }
                return "\\u" + string;
            }
            return "\\" + Integer.toString(n, 8);
        }
        return String.valueOf((char)n);
    }

    public String escapeString(String string) {
        String string2 = new String();
        for (int i = 0; i < string.length(); ++i) {
            string2 = string2 + this.escapeChar(string.charAt(i));
        }
        return string2;
    }

    public String getTargetCharLiteralFromANTLRCharLiteral(CodeGenerator codeGenerator, String string) {
        int n = Grammar.getCharValueFromGrammarCharLiteral(string);
        String string2 = "'";
        if (codeGenerator.grammar.getMaxCharValue() > 255) {
            string2 = "L'";
        } else if ((n & 0x80) != 0) {
            return "" + n;
        }
        return string2 + this.escapeChar(n) + "'";
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator codeGenerator, String string) {
        StringBuffer stringBuffer = Grammar.getUnescapedStringFromGrammarStringLiteral(string);
        String string2 = "\"";
        if (codeGenerator.grammar.getMaxCharValue() > 255) {
            string2 = "L\"";
        }
        return string2 + this.escapeString(stringBuffer.toString()) + "\"";
    }

    public int getMaxCharValue(CodeGenerator codeGenerator) {
        int n = 255;
        if (n <= 255) {
            return 255;
        }
        return n;
    }
}

