/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.antlr.runtime.CharStream;

public class ANTLRMMapFileStream
implements CharStream {
    protected int p = 0;
    String fileName;
    protected int line = 1;
    protected int charPositionInLine = 0;
    CharBuffer mmap;

    public ANTLRMMapFileStream() {
    }

    public ANTLRMMapFileStream(String string) throws IOException {
        this.load(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string) throws IOException {
        this.fileName = string;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            Charset charset = Charset.forName("ISO-8859-1");
            CharsetDecoder charsetDecoder = charset.newDecoder();
            abstractInterruptibleChannel = new FileInputStream(string).getChannel();
            long l = ((FileChannel)abstractInterruptibleChannel).size();
            MappedByteBuffer mappedByteBuffer = ((FileChannel)abstractInterruptibleChannel).map(FileChannel.MapMode.READ_ONLY, 0L, l);
            this.mmap = charsetDecoder.decode(mappedByteBuffer);
        }
        finally {
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
        }
    }

    public void reset() {
        this.line = 1;
        this.charPositionInLine = 0;
    }

    public void consume() {
        if (this.p < this.mmap.length()) {
            ++this.charPositionInLine;
            if (this.mmap.get(this.p) == '\n') {
                ++this.line;
                this.charPositionInLine = 0;
            }
            ++this.p;
        }
    }

    public int LA(int n) {
        if (this.p + n - 1 >= this.mmap.length()) {
            return -1;
        }
        return this.mmap.get(this.p + n - 1);
    }

    public int LT(int n) {
        return this.LA(n);
    }

    public int mark() {
        return this.index();
    }

    public void release(int n) {
        throw new NoSuchMethodError("not implemented yet");
    }

    public int index() {
        return this.p;
    }

    public int size() {
        return this.mmap.length();
    }

    public void rewind(int n) {
        this.p = n;
    }

    public void seek(int n) {
        throw new NoSuchMethodError("not implemented yet");
    }

    public String substring(int n, int n2) {
        return ((Object)this.mmap.subSequence(n, n2 - n + 1)).toString();
    }

    public int getLine() {
        return this.line;
    }

    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public void setCharPositionInLine(int n) {
        this.charPositionInLine = n;
    }

    public String getSourceName() {
        return this.fileName;
    }
}

