/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import org.drools.PackageIntegrationException;
import org.drools.RuleBase;
import org.drools.leaps.LeapsRuleBase;
import org.drools.reteoo.ReteooRuleBase;

public class RuleBaseFactory {
    private static final RuleBaseFactory INSTANCE = new RuleBaseFactory();

    private RuleBaseFactory() {
    }

    public static RuleBaseFactory getInstance() {
        return INSTANCE;
    }

    public static RuleBase newRuleBase() {
        return RuleBaseFactory.newRuleBase(1);
    }

    public static RuleBase newRuleBase(int n) {
        switch (n) {
            case 1: {
                return new ReteooRuleBase();
            }
            case 2: {
                try {
                    return new LeapsRuleBase();
                }
                catch (PackageIntegrationException packageIntegrationException) {
                    throw new IllegalStateException("Unable to create Leaps engine. Error: " + packageIntegrationException.getMessage());
                }
            }
        }
        throw new IllegalArgumentException("Unknown engine type: " + n);
    }
}

